function [avg_mat, std_mat] = binary_run(N, m)
    values = linspace(0.1, 0.5, 20);
    n_rep = 20;
    for i = 1:n_rep
        [train_tmp, valid_tmp, test_tmp] = binary_data(N, p, theta_true);
        data_tmp = data_allocate(train_tmp, valid_tmp, test_tmp, m);
        tic;
        [error_iter_0, ell2_0, F_score_0] = mean_valid_msda(data_tmp, 10, values, theta_true);
        CSL_time = toc;
        [error, ell_2, F_score, DC_time] = Debias_DC(data_tmp, theta_true);

        mis_error_set(i, :) = [error_iter_0(11) error];
        ell2_set(i, :) = [ell2_0(11) ell_2];
        Fscore_set(i, :) = [F_score_0(11) F_score];
        time_set(i, :) = [CSL_time, DC_time];
    end
    avg_mis_error_1 = mean(mis_error_set, 1);
    avg_ell2_1 = mean(ell2_set, 1);
    avg_Fscore_1 = mean(Fscore_set, 1);
    avg_time = mean(time_set, 1);

    avg_mat = [avg_mis_error_1; avg_ell2_1; avg_Fscore_1; avg_time];

    std_mis_error_1 = std(mis_error_set, 1);
    std_ell2_1 = std(ell2_set, 1);
    std_Fscore_1 = std(Fscore_set, 1);
    std_time = std(time_set, 1);

    std_mat = [std_mis_error_1; std_ell2_1; std_Fscore_1, std_time];
