function data = data_allocate(train, valid, test, M)
    train_X = train{1, 1};
    train_Y = train{1, 2};
    valid_X = valid{1, 1};
    valid_Y = valid{1, 2};
    test_X = test{1, 1};
    test_Y = test{1, 2};
    N = size(train_X,1);
    data = cell(M+2, 2);

    n = floor(N/M);

    %Normal machine
    for m = 1 : (M-1)
        index = (m-1) * n +1 : 1 :m * n;
        data{m,1} = train_X(index,:);
        data{m,2} = train_Y(index);
    end

    index = n*(M-1)+1 : 1 : N;
    data{M,1} = train_X(index,:);
    data{M,2} = train_Y(index);

    % valid set
    data{M+1, 1} = valid_X;
    data{M+1, 2} = valid_Y;

    % test set
    data{M+2, 1} = test_X;
    data{M+2, 2} = test_Y;
end