function F1 = F1_score(s, theta_hat)
    p = size(theta_hat, 1);
    K = size(theta_hat, 2);
    for j = 1:p
        zero_ind(j) = sum(theta_hat(j, :) == 0);
    end
    S_hat = setdiff(1:p, find(zero_ind == K));
    S = 1:s;
    precision = length(intersect(S, S_hat))/length(S_hat);
    recall = length(intersect(S, S_hat))/length(S);
    F1 = 2 * precision * recall / (precision + recall); 
end