%% binary-class task
p = 300;
N = 10000; % total sample size
m = 20;
[train_tmp, valid_tmp, test_tmp] = binary_data(N, p, theta_true); % generate training set, validation set and test set
data_tmp = data_allocate(train_tmp, valid_tmp, test_tmp, m); % divide training set into 20 machines

tic;
values = linspace(0.1, 0.5, 20);
T = 10; %number of communication rounds
[error_iter_0, ell2_0, F_score_0] = mean_valid_msda(data_tmp, T, values, theta_true); % run Mean-DSLDA
CSL_time = toc;
[error, ell_2, F_score, DC_time] = Debias_DC(data_tmp, theta_true); % run DC-LPD


[avg_mat_1, std_mat_1] = binary_run(N, 20, p, theta_true); % obtain the results in Table 2 (p = 200).

