function [error, ell_2, F_score] = Debias_DC(data, theta_true)
    M = size(data, 1) - 2; % number of machines of training set
    test_X = data{M+2, 1};  %last one : test dataset
    test_Y = data{M+2, 2};
    valid_X = data{M+1, 1};
    valid_Y = data{M+1, 2};
    p = size(test_X, 2);

    mu_est = zeros(p, 2);
    X_t = data{1,1};
    Y_t = data{1,2};
    for m = 2:M
        X_t = [X_t; data{m,1}];
        Y_t = [Y_t; data{m,2}];
    end
    cov_class = zeros(p, p);
    for k = 1:2
        ind_k = find(Y_t == k);
        X_class = X_t(ind_k,:);
        mu_est(:,k) = mean(X_class, 1)';
        cov_class = cov_class + size(X_class,1) * cov(X_class);
    end
    mu_hat = (mu_est(:, 1) + mu_est(:, 2))/2;

    theta_matrix = zeros(p, M);
    for k = 1:M
        local_data{1,1} = data{k, 1};
        local_data{1,2} = data{k, 2};
        valid_data{1,1} = valid_X;
        valid_data{1,2} = valid_Y;

        theta_matrix(:, k) = LPD_DC(local_data, valid_data);
    end

    ht_values = linspace(0.01, 1, 20);
    avg_db_theta = mean(theta_matrix, 2);
    for i = 1:20
        ht_theta = avg_db_theta;
        ht_theta(find(abs(avg_db_theta) > ht_values(i))) = 0;
        pred_value = (valid_X - mu_hat') * ht_theta;
        pred_Y = pred_value ;
        pred_Y(find(pred_value > 0)) = 1;
        pred_Y(find(pred_value <= 0)) = 2;
        error_cv(i) = 1 - mean(pred_Y == valid_Y);
    end

    min_ind = find(error_cv == min(error_cv));
    ht_lambda = ht_values(min_ind(1));
    ht_theta_hat = avg_db_theta;
    ht_theta_hat(find(abs(avg_db_theta) > ht_lambda)) = 0;
    ell_2 = norm(ht_theta_hat - theta_true, 2);
    F_score = F1_score(4, ht_theta_hat);

    test_pred_value = (test_X - mu_hat') * ht_theta_hat;
    test_pred_Y = test_pred_value ;
    test_pred_Y(find(test_pred_value > 0)) = 1;
    test_pred_Y(find(test_pred_value <= 0)) = 2;
    error = 1 - mean(test_pred_Y == test_Y);




