function [error, ell_2, F_score] = LPD_DC(train_data, valid_data, values, theta_true)
    train_X = train_data{1, 1};
    train_Y = train_data{1, 2};

    valid_X = valid_data{1, 1};
    valid_Y = valid_data{1, 2};
    p = size(valid_X, 2);

    cov_class = zeros(p, p);
    for k = 1:2
        ind_k = find(train_Y == k);
        X_class = train_X(ind_k,:);
        mu_hat(:,k) = mean(X_class, 1)';
        cov_class = cov_class + size(X_class,1) * cov(X_class);
    end
    Sigma = cov_class/size(train_X, 1);
    delta = mu_hat(:, 1) - mu_hat(:, 2);
    mu_hat = (mu_hat(:, 1) + mu_hat(:, 2))/2;

    x0 = zeros(p, 1);
    values = linspace(0.01, 1, 20);

    %% solve LPD
    for i = 1:20
        lambda = values(i);
        xp = clime(x0, Sigma,  delta, lambda);
        beta_set(:, i) = xp;
        pred_value = (valid_X - mu_hat') * xp;
        pred_Y = pred_value ;
        pred_Y(find(pred_value > 0)) = 1;
        pred_Y(find(pred_value <= 0)) = 2;
        error_cv(i) = 1 - mean(pred_Y == valid_Y);
    end

    min_error_ind = find(error_cv == min(error_cv));
    beta_hat = beta_set(:, min_error_ind(1));

    %% solve CLIME
    for i = 1:20
        lambda = values(i);
        Omega_tmp = zeros(p, p);
        for j = 1:p
            e_j = zeros(p, 1);
            e_j(j) = 1;
            Omega_tmp(:, j) = clime(x0, Sigma, e_j, lambda);
        end
        likelihood(i) = trace(Sigma * Omega_tmp') - log(det(Omega_tmp));
        Omega_list{i} = Omega_tmp;
    end
    l_ind = find(likelihood == min(likelihood));
    lambda_c = Omega_list{l_ind(1)};
    









