function [train, valid, test] = binary_data(N, p)
    nk = N/2;
    sigma = zeros(p,p);
    for i = 1:p
       for k = 1:p
          sigma(i,k) = 0.8^(abs(i-k));
       end
    end  
    mu = zeros(p, 2);
    mu(:, 2) = [ones(10,1);zeros(p-10,1)];
 
    X = [];
    Y = [];
    for k = 1:2
       X = [X; mvnrnd(mu(:,k), sigma, nk)];
       Y = [Y; ones(nk, 1)*k];
    end
 
    % valid set, size = 1000
    valid_X = [];
    valid_Y = [];
    for k = 1:2
        valid_X = [valid_X; mvnrnd(mu(:,k), sigma, 1000/2)];
        valid_Y = [valid_Y; ones(1000/2, 1)*k];
    end
    valid{1, 1} = valid_X;
    valid{1, 2} = valid_Y;
 
    % test set, size = 1000
    test_X = [];
    test_Y = [];
    for k = 1:2
        test_X = [test_X; mvnrnd(mu(:,k), sigma, 1000/2)];
        test_Y = [test_Y; ones(1000/2, 1)*k];
    end
    test{1, 1} = test_X;
    test{1, 2} = test_Y;
 
    index_rand = randsample(1:N, N);
    train{1,1} = X(index_rand, :);
    train{1,2} = Y(index_rand, :);
 end