function theta_new =  lasso_ISTA(H, g, lambda, eta)
    p = size(H, 1);
    theta_old = zeros(p, 1);
    theta_new = zeros(p, 1);
    theta_diff = 1;
    while theta_diff > 1e-4
        theta_update = theta_old - eta*(H*theta_old - g);
        theta_new = ST(theta_update, lambda*eta);
        theta_diff = max(abs(theta_new - theta_old));
        if theta_diff > 1e2
            fprintf('bomb!')
            break
        end
        theta_old = theta_new;
    end
end