%% synthetic data simulation

% theta ture
p = 200; K = 2;
sigma = zeros(p,p);
for i = 1:p
    for k = 1:p
        sigma(i,k) = 0.5^(abs(i-k));
    end
end  
beta = zeros(p,K);
mu = zeros(p,K);
for k = 1:K
    beta(2*k-1,k)=1.6;
    beta(2*k,k) = 1.6;
    mu(:,k) = sigma * beta(:,k);
end
theta_true = beta - beta(:, 1);
theta_true(:, 1) = [];

n = 200; % replication number

%% Effect of the number of local machines
% M = 50, N = 5000, alpha = 0, 0.1, 0.2

values = linspace(1, 2, 10);
values_c = linspace(1, 2, 10);
for i = 1:n
    [train_2_tmp, valid_2_tmp, test_2_tmp] = generate_data_multi(10000, p, K);
    data_20_tmp = data_with_Byzantine(train_2_tmp, valid_2_tmp, test_2_tmp, K, 20, 0);
    data_21_tmp = data_with_Byzantine(train_2_tmp, valid_2_tmp, test_2_tmp, 5, 40, 0);
    data_22_tmp = data_with_Byzantine(train_2_tmp, valid_2_tmp, test_2_tmp, 5, 60, 0);
    data_23_tmp = data_with_Byzantine(train_2_tmp, valid_2_tmp, test_2_tmp, 5, 80, 0);
    data_24_tmp = data_with_Byzantine(train_2_tmp, valid_2_tmp, test_2_tmp, 5, 100, 0);
    [error_iter(:, i), r_error_iter(:, i), ell2(:, i), ell2_1(:, i), F_score(:, i), rF_score(:, i)] = valid_msda(data_20_tmp, 5, 10, values, theta_true);
    [c_error(i,:), c_ell_2(i,:), c_F_score(i,:)] = msda_cen(data_21_tmp, K, values_c, theta_true);
    [error_iter_21(:, i), r_error_iter_21(:, i), ell2_21(:, i), ell2_1_21(:, i), F_score_21(:, i), rF_score_21(:, i)] = valid_msda(data_21_tmp, 5, 10, values, theta_true);
    [error_iter_22(:, i), r_error_iter_22(:, i), ell2_22(:, i), ell2_1_22(:, i), F_score_22(:, i), rF_score_22(:, i)] = valid_msda(data_22_tmp, 5, 10, values, theta_true);
    [error_iter_23(:, i), r_error_iter_23(:, i), ell2_23(:, i), ell2_1_23(:, i), F_score_23(:, i), rF_score_23(:, i)] = valid_msda(data_23_tmp, 5, 10, values, theta_true);
    [error_iter_24(:, i), r_error_iter_24(:, i), ell2_24(:, i), ell2_1_24(:, i), F_score_24(:, i), rF_score_24(:, i)] = valid_msda(data_24_tmp, 5, 10, values, theta_true);
end
save('num_local_1.mat')

error_matrix_mean = [mean(error_iter, 2) mean(error_iter_21, 2) mean(error_iter_22, 2) mean(error_iter_23, 2) mean(error_iter_24, 2)];
error_matrix_median = [mean(r_error_iter, 2) mean(r_error_iter_21, 2) mean(r_error_iter_22, 2) mean(r_error_iter_23, 2) mean(r_error_iter_24, 2)];
ell2_matrix_mean = [mean(ell2, 2) mean(ell2_21, 2) mean(ell2_22, 2) mean(ell2_23, 2) mean(ell2_24, 2)];
ell2_matrix_median = [mean(ell2_1, 2) mean(ell2_1_21, 2) mean(ell2_1_22, 2) mean(ell2_1_23, 2) mean(ell2_1_24, 2)];
F1_score_matrix_mean = [mean(F_score, 2) mean(F_score_21, 2) mean(F_score_22, 2) mean(F_score_23, 2) mean(F_score_24, 2)];
F1_score_matrix_median = [mean(rF_score, 2) mean(rF_score_21, 2) mean(rF_score_22, 2) mean(rF_score_23, 2) mean(rF_score_24, 2)];

c_error_avg = mean(c_error, 1);
c_ell_2_avg = mean(c_ell_2, 1);
c_F_score_avg = mean(c_F_score, 1);

ell2_matrix0 = ell2_matrix(:, [1,2,4,6]);

%% Effect of local sample size
% m = 50, n = 200, 400, 600, 800, 1000
values = linspace(0.5, 1.5, 10);
values_c = linspace(0.5, 1.5, 10);
tic;
for i = 1:n
    [train_0_tmp, valid_0_tmp, test_0_tmp] = generate_data_multi(200*50, p, 5);
    [train_1_tmp, valid_1_tmp, test_1_tmp] = generate_data_multi(400*50, p, 5);
    [train_2_tmp, valid_2_tmp, test_2_tmp] = generate_data_multi(600*50, p, 5);
    [train_3_tmp, valid_3_tmp, test_3_tmp] = generate_data_multi(800*50, p, 5);
    [train_4_tmp, valid_4_tmp, test_4_tmp] = generate_data_multi(1000*50, p, 5);

    data_0_tmp = data_with_Byzantine(train_0_tmp, valid_0_tmp, test_0_tmp, 5, 50, 0);
    data_1_tmp = data_with_Byzantine(train_1_tmp, valid_1_tmp, test_1_tmp, 5, 50, 0);
    data_2_tmp = data_with_Byzantine(train_2_tmp, valid_2_tmp, test_2_tmp, 5, 50, 0);
    data_3_tmp = data_with_Byzantine(train_3_tmp, valid_3_tmp, test_3_tmp, 5, 50, 0);
    data_4_tmp = data_with_Byzantine(train_4_tmp, valid_4_tmp, test_4_tmp, 5, 50, 0);

    [c_error_0(i,:), c_ell2_0(i,:), c_F_score_0(i,:)] = msda_cen(data_0_tmp, K, values_c, theta_true);
    [c_error_1(i,:), c_ell2_1(i,:), c_F_score_1(i,:)] = msda_cen(data_1_tmp, K, values_c, theta_true);
    [c_error_2(i,:), c_ell2_2(i,:), c_F_score_2(i,:)] = msda_cen(data_2_tmp, K, values_c, theta_true);
    [c_error_3(i,:), c_ell2_3(i,:), c_F_score_3(i,:)] = msda_cen(data_3_tmp, K, values_c, theta_true);
    [c_error_4(i,:), c_ell2_4(i,:), c_F_score_4(i,:)] = msda_cen(data_4_tmp, K, values_c, theta_true);

    data_0_tmp1 = data_with_Byzantine(train_0_tmp, valid_0_tmp, test_0_tmp, 5, 50, 5);
    data_1_tmp1 = data_with_Byzantine(train_1_tmp, valid_1_tmp, test_1_tmp, 5, 50, 5);
    data_2_tmp1 = data_with_Byzantine(train_2_tmp, valid_2_tmp, test_2_tmp, 5, 50, 5);
    data_3_tmp1 = data_with_Byzantine(train_3_tmp, valid_3_tmp, test_3_tmp, 5, 50, 5);
    data_4_tmp1 = data_with_Byzantine(train_4_tmp, valid_4_tmp, test_4_tmp, 5, 50, 5);

    [error_iter_0(:, i), ell2_0(:, i), F_score_0(:, i)] = mean_valid_msda(data_0_tmp, 5, 5, values, theta_true);
    [error_iter_1(:, i), ell2_1(:, i), F_score_1(:, i)] = mean_valid_msda(data_1_tmp, 5, 5, values, theta_true);
    [error_iter_2(:, i), ell2_2(:, i), F_score_2(:, i)] = mean_valid_msda(data_2_tmp, 5, 5, values, theta_true);
    [error_iter_3(:, i), ell2_3(:, i), F_score_3(:, i)] = mean_valid_msda(data_3_tmp, 5, 5, values, theta_true);
    [error_iter_4(:, i), ell2_4(:, i), F_score_4(:, i)] = mean_valid_msda(data_4_tmp, 5, 5, values, theta_true);

    [r_error_iter_0(:, i), r_ell2_0(:, i), rF_score_0(:, i)] = median_valid_msda(data_0_tmp1, 5, 5, values, theta_true);
    [r_error_iter_1(:, i), r_ell2_1(:, i), rF_score_1(:, i)] = median_valid_msda(data_1_tmp1, 5, 5, values, theta_true);
    [r_error_iter_2(:, i), r_ell2_2(:, i), rF_score_2(:, i)] = median_valid_msda(data_2_tmp1, 5, 5, values, theta_true);
    [r_error_iter_3(:, i), r_ell2_3(:, i), rF_score_3(:, i)] = median_valid_msda(data_3_tmp1, 5, 5, values, theta_true);
    [r_error_iter_4(:, i), r_ell2_4(:, i), rF_score_4(:, i)] = median_valid_msda(data_4_tmp1, 5, 5, values, theta_true);

    i
end
toc;
save('size_local.mat')
%C-MSDA
c_error_avg = [mean(c_error_0) mean(c_error_1) mean(c_error_2) mean(c_error_3) mean(c_error_4)];
c_error_std = [std(c_error_0) std(c_error_1) std(c_error_2) std(c_error_3) std(c_error_4)];

c_ell2_avg = [mean(c_ell2_0) mean(c_ell2_1) mean(c_ell2_2) mean(c_ell2_3) mean(c_ell2_4)];
c_ell2_std = [std(c_ell2_0) std(c_ell2_1) std(c_ell2_2) std(c_ell2_3) std(c_ell2_4)];

c_Fscore_avg = [mean(c_F_score_0) mean(c_F_score_1) mean(c_F_score_2) mean(c_F_score_3) mean(c_F_score_4)];
c_Fscore_std = [std(c_F_score_0) std(c_F_score_1) std(c_F_score_2) std(c_F_score_3) std(c_F_score_4)];

%mean-DSLDA
error_avg = [mean(error_iter_0(6, :)) mean(error_iter_1(6, :)) mean(error_iter_2(6, :)) mean(error_iter_3(6, :)) mean(error_iter_4(6, :))];
error_std = [std(error_iter_0(6, :)) std(error_iter_1(6, :)) std(error_iter_2(6, :)) std(error_iter_3(6, :)) std(error_iter_4(6, :))];

ell2_avg = [mean(ell2_0(6, :)) mean(ell2_1(6, :)) mean(ell2_2(6, :)) mean(ell2_3(6, :)) mean(ell2_4(6, :))];
ell2_std = [std(ell2_0(6, :)) std(ell2_1(6, :)) std(ell2_2(6, :)) std(ell2_3(6, :)) std(ell2_4(6, :))];

Fscore_avg = [mean(F_score_0(6, :)) mean(F_score_1(6, :)) mean(F_score_2(6, :)) mean(F_score_3(6, :)) mean(F_score_4(6, :))];
Fscore_std = [std(F_score_0(6, :)) std(F_score_1(6, :)) std(F_score_2(6, :)) std(F_score_3(6, :)) std(F_score_4(6, :))];

%Median-DSLDA
r_error_avg = [mean(r_error_iter_0(6, :)) mean(r_error_iter_1(6, :)) mean(r_error_iter_2(6, :)) mean(r_error_iter_3(6, :)) mean(r_error_iter_4(6, :))];
r_error_std = [std(r_error_iter_0(6, :)) std(r_error_iter_1(6, :)) std(r_error_iter_2(6, :)) std(r_error_iter_3(6, :)) std(r_error_iter_4(6, :))];

r_ell2_avg = [mean(r_ell2_0(6, :)) mean(r_ell2_1(6, :)) mean(r_ell2_2(6, :)) mean(r_ell2_3(6, :)) mean(r_ell2_4(6, :))];
r_ell2_std = [std(r_ell2_0(6, :)) std(r_ell2_1(6, :)) std(r_ell2_2(6, :)) std(r_ell2_3(6, :)) std(r_ell2_4(6, :))];

r_Fscore_avg = [mean(rF_score_0(6, :)) mean(rF_score_1(6, :)) mean(rF_score_2(6, :)) mean(rF_score_3(6, :)) mean(rF_score_4(6, :))];
r_Fscore_std = [std(rF_score_0(6, :)) std(rF_score_1(6, :)) std(rF_score_2(6, :)) std(rF_score_3(6, :)) std(rF_score_4(6, :))];

%% System I
values = linspace(0.5, 2, 10);
T = 20;
for i = 1:200
    [train, valid, test] = generate_data_multi(10000, p, 5);
    data = data_with_Byzantine(train, valid, test, 5, 50, 0);
    [c_error(i,:), c_ell_2(i,:), c_F_score(i,:)] = msda_cen(data, K, values, theta_true);
    [d_error_iter(:, i), d_ell_2(:, i), d_F_score(:, i)] = mean_valid_msda(data, K, T, values, theta_true);
    [md_error_iter(:, i), md_ell_2(:, i), md_F_score(:, i)] = median_valid_msda(data, K, T, values, theta_true);
end

error_iter = mean(d_error_iter, 2);
ell2_iter = mean(d_ell_2, 2);
F_score_iter = mean(d_F_score, 2);

sd_error_iter = std(d_error_iter')';
sd_ell2_iter = std(d_ell_2')';
sd_F_score_iter = std(d_F_score')';


msda_error = mean(c_error, 1);
msda_ell = mean(c_ell_2, 1);
msda_F_score = mean(c_F_score, 1);

sd_msda_error = std(c_error, 1);
sd_msda_ell = std(c_ell_2, 1);
sd_msda_F_score = std(c_F_score, 1);


%% System II
values = linspace(0.5, 1.5, 10);
T = 20;
tic;
for i = 1:200
    [train, valid, test] = generate_data_multi(10000, p, 5);
    data = data_with_Byzantine(train, valid, test, 5, 50, 5);
    datac = data_with_Byzantine(train, valid, test, 5, 50, 0);
    [c_error(i,:), c_ell_2(i,:), c_F_score(i,:)] = msda_cen(datac, K, values, theta_true);
    [md_error_iter(:, i), md_ell_2(:, i), md_F_score(:, i)] = median_valid_msda(data, K, T, values, theta_true);
    i
end
toc;
save('sys2.mat')


m_error_iter = mean(md_error_iter, 2);
m_ell2_iter = mean(md_ell_2, 2);
m_F_score_iter = mean(md_F_score, 2);

msda_error = mean(c_error, 1);
msda_ell = mean(c_ell_2, 1);
msda_F_score = mean(c_F_score, 1);


figure1 = figure;
% ??�? axes
axes1 = axes('Parent',figure1);
hold(axes1,'on');

plot1 = plot(0:20, m_error_iter, 'LineWidth',2);
set(plot1(1),'DisplayName','Median-DSLDA, \alpha = 0.1','Marker','+',...
    'Color',[0.635294117647059 0.07843137254902 0.184313725490196]);
line([0, 20], [msda_error(1), msda_error(1)],'DisplayName','C-MSDA','Parent',axes1,'LineWidth',2,...
    'LineStyle','-',...
    'Color',[0.466666666666667 0.674509803921569 0.188235294117647]);

% ??�? ylabel
ylabel({'Misclassification Rate'},'FontSize',18);
xlabel({'Iteration'},'FontSize',18);
box(axes1,'on');
legend1 = legend(axes1,'show');
set(legend1,...
    'Position',[0.604017857142857 0.635714291790058 0.259821428571428 0.18452380952381],...
    'FontSize',20);



figure2 = figure;
% ??�? axes
axes1 = axes('Parent',figure2);
hold(axes1,'on');

plot1 = plot(0:20, m_ell2_iter, 'LineWidth',2);
set(plot1(1),'DisplayName','Median-DSLDA, \alpha = 0.1','Marker','+',...
    'Color',[0.635294117647059 0.07843137254902 0.184313725490196]);
line([0, 20], [msda_ell(1), msda_ell(1)],'DisplayName','C-MSDA','Parent',axes1,'LineWidth',2,...
    'LineStyle','-',...
    'Color',[0.466666666666667 0.674509803921569 0.188235294117647]);
% ??�? ylabel
ylabel({'L_2 Error'},'FontSize',18);
xlabel({'Iteration'},'FontSize',18);
box(axes1,'on');
legend1 = legend(axes1,'show');
set(legend1,...
    'Position',[0.604017857142857 0.635714291790058 0.259821428571428 0.18452380952381],...
    'FontSize',20);


figure3 = figure;
% ??�? axes
axes1 = axes('Parent',figure3);
hold(axes1,'on');

plot1 = plot(0:20, m_F_score_iter, 'LineWidth',2);
set(plot1(1),'DisplayName','Median-DSLDA, \alpha = 0.1','Marker','+',...
    'Color',[0.635294117647059 0.07843137254902 0.184313725490196]);
line([0, 20], [msda_F_score(1), msda_F_score(1)],'DisplayName','C-MSDA','Parent',axes1,'LineWidth',2,...
    'LineStyle','-',...
    'Color',[0.466666666666667 0.674509803921569 0.188235294117647]);
% ??�? ylabel
ylabel({'F_1 Score'},'FontSize',18);
xlabel({'Iteration'},'FontSize',18);
box(axes1,'on');
legend1 = legend(axes1,'show');
set(legend1,...
    'Position',[0.604017857142857 0.635714291790058 0.259821428571428 0.18452380952381],...
    'FontSize',20);


%% effect of dimension
values = linspace(0.5, 1.5, 20);
values_c = linspace(0.3, 1.5, 20);
n = 50;
K = 5;
tic;
for i = 1:n
    [train_0_tmp, valid_0_tmp, test_0_tmp, theta_true_1] = generate_data_multi(200*50, 200, 5);
    [train_1_tmp, valid_1_tmp, test_1_tmp, theta_true_2] = generate_data_multi(200*50, 400, 5);
    [train_2_tmp, valid_2_tmp, test_2_tmp, theta_true_3] = generate_data_multi(200*50, 600, 5);
    [train_3_tmp, valid_3_tmp, test_3_tmp, theta_true_4] = generate_data_multi(200*50, 800, 5);
    [train_4_tmp, valid_4_tmp, test_4_tmp, theta_true_5] = generate_data_multi(200*50, 1000, 5);

    data_0_tmp = data_with_Byzantine(train_0_tmp, valid_0_tmp, test_0_tmp, 5, 50, 0);
    data_1_tmp = data_with_Byzantine(train_1_tmp, valid_1_tmp, test_1_tmp, 5, 50, 0);
    data_2_tmp = data_with_Byzantine(train_2_tmp, valid_2_tmp, test_2_tmp, 5, 50, 0);
    data_3_tmp = data_with_Byzantine(train_3_tmp, valid_3_tmp, test_3_tmp, 5, 50, 0);
    data_4_tmp = data_with_Byzantine(train_4_tmp, valid_4_tmp, test_4_tmp, 5, 50, 0);

    [c_error_0(i,:), c_ell2_0(i,:), c_F_score_0(i,:)] = msda_cen(data_0_tmp, K, values_c, theta_true_1);
    [c_error_1(i,:), c_ell2_1(i,:), c_F_score_1(i,:)] = msda_cen(data_1_tmp, K, values_c, theta_true_2);
    [c_error_2(i,:), c_ell2_2(i,:), c_F_score_2(i,:)] = msda_cen(data_2_tmp, K, values_c, theta_true_3);
    [c_error_3(i,:), c_ell2_3(i,:), c_F_score_3(i,:)] = msda_cen(data_3_tmp, K, values_c, theta_true_4);
    [c_error_4(i,:), c_ell2_4(i,:), c_F_score_4(i,:)] = msda_cen(data_4_tmp, K, values_c, theta_true_5);

    data_0_tmp1 = data_with_Byzantine(train_0_tmp, valid_0_tmp, test_0_tmp, 5, 50, 5);
    data_1_tmp1 = data_with_Byzantine(train_1_tmp, valid_1_tmp, test_1_tmp, 5, 50, 5);
    data_2_tmp1 = data_with_Byzantine(train_2_tmp, valid_2_tmp, test_2_tmp, 5, 50, 5);
    data_3_tmp1 = data_with_Byzantine(train_3_tmp, valid_3_tmp, test_3_tmp, 5, 50, 5);
    data_4_tmp1 = data_with_Byzantine(train_4_tmp, valid_4_tmp, test_4_tmp, 5, 50, 5);

    [error_iter_0(:, i), ell2_0(:, i), F_score_0(:, i)] = mean_valid_msda(data_0_tmp, 5, 5, values, theta_true_1);
    [error_iter_1(:, i), ell2_1(:, i), F_score_1(:, i)] = mean_valid_msda(data_1_tmp, 5, 5, values, theta_true_2);
    [error_iter_2(:, i), ell2_2(:, i), F_score_2(:, i)] = mean_valid_msda(data_2_tmp, 5, 5, values, theta_true_3);
    [error_iter_3(:, i), ell2_3(:, i), F_score_3(:, i)] = mean_valid_msda(data_3_tmp, 5, 5, values, theta_true_4);
    [error_iter_4(:, i), ell2_4(:, i), F_score_4(:, i)] = mean_valid_msda(data_4_tmp, 5, 5, values, theta_true_5);

    [error_iter_b0(:, i), ell2_b0(:, i), F_score_b0(:, i)] = mean_valid_msda(data_0_tmp1, 5, 5, values, theta_true_1);
    [error_iter_b1(:, i), ell2_b1(:, i), F_score_b1(:, i)] = mean_valid_msda(data_1_tmp1, 5, 5, values, theta_true_2);
    [error_iter_b2(:, i), ell2_b2(:, i), F_score_b2(:, i)] = mean_valid_msda(data_2_tmp1, 5, 5, values, theta_true_3);
    [error_iter_b3(:, i), ell2_b3(:, i), F_score_b3(:, i)] = mean_valid_msda(data_3_tmp1, 5, 5, values, theta_true_4);
    [error_iter_b4(:, i), ell2_b4(:, i), F_score_b4(:, i)] = mean_valid_msda(data_4_tmp1, 5, 5, values, theta_true_5);

    [r_0_error_0_iter_0_0(:, i), r_0_ell2_0(:, i), rF_0_score_0(:, i)] = median_valid_msda(data_0_tmp, 5, 5, values, theta_true_1);
    [r_0_error_0_iter_0_1(:, i), r_0_ell2_1(:, i), rF_0_score_1(:, i)] = median_valid_msda(data_1_tmp, 5, 5, values, theta_true_2);
    [r_0_error_0_iter_0_2(:, i), r_0_ell2_2(:, i), rF_0_score_2(:, i)] = median_valid_msda(data_2_tmp, 5, 5, values, theta_true_3);
    [r_0_error_0_iter_0_3(:, i), r_0_ell2_3(:, i), rF_0_score_3(:, i)] = median_valid_msda(data_3_tmp, 5, 5, values, theta_true_4);
    [r_0_error_0_iter_0_4(:, i), r_0_ell2_4(:, i), rF_0_score_4(:, i)] = median_valid_msda(data_4_tmp, 5, 5, values, theta_true_5);

    [r_error_iter_0(:, i), r_ell2_0(:, i), rF_score_0(:, i)] = median_valid_msda(data_0_tmp1, 5, 5, values, theta_true_1);
    [r_error_iter_1(:, i), r_ell2_1(:, i), rF_score_1(:, i)] = median_valid_msda(data_1_tmp1, 5, 5, values, theta_true_2);
    [r_error_iter_2(:, i), r_ell2_2(:, i), rF_score_2(:, i)] = median_valid_msda(data_2_tmp1, 5, 5, values, theta_true_3);
    [r_error_iter_3(:, i), r_ell2_3(:, i), rF_score_3(:, i)] = median_valid_msda(data_3_tmp1, 5, 5, values, theta_true_4);
    [r_error_iter_4(:, i), r_ell2_4(:, i), rF_score_4(:, i)] = median_valid_msda(data_4_tmp1, 5, 5, values, theta_true_5);

    i
end
toc;
[r0, c0] = find(ell2_b0 > 1e2);
[r1, c1] = find(ell2_b1 > 1e2);
[r2, c2] = find(ell2_b2 > 1e2);
[r3, c3] = find(ell2_b3 > 1e2);
[r4, c4] = find(ell2_b4 > 1e2);

ell2_b0(:, 27) = [];
ell2_b1(:, 42) = [];
ell2_b1(:, 43) = [];
ell2_b3(:, 35) = [];
ell2_b4(:, 40) = [];

error_iter_b0(:, 27) = [];
error_iter_b1(:, 42) = [];
error_iter_b1(:, 43) = [];
error_iter_b3(:, 35) = [];
error_iter_b4(:, 40) = [];

F_score_b0(:, 27) = [];
F_score_b1(:, 42) = [];
F_score_b1(:, 43) = [];
F_score_b3(:, 35) = [];
F_score_b4(:, 40) = [];




%% ell_2 error
avg_cen_ell2 = [mean(c_ell2_0) mean(c_ell2_1) mean(c_ell2_2) mean(c_ell2_3) mean(c_ell2_4)]';
avg_mean_ell2 = [mean(ell2_0(6, :)) mean(ell2_1(6,:)) mean(ell2_2(6, :)) mean(ell2_3(6, :)) mean(ell2_4(6, :))]';
avg_mean_b_ell2 = [mean(ell2_b0(6, :)) mean(ell2_b1(6, :)) mean(ell2_b2(6, :)) mean(ell2_b3(6, :)) mean(ell2_b4(6, :))]';
avg_median_ell2 = [mean(r_0_ell2_0(6, :)) mean(r_0_ell2_1(6,:)) mean(r_0_ell2_2(6, :)) mean(r_0_ell2_3(6, :)) mean(r_0_ell2_4(6, :))]';
avg_median_b_ell2 = [mean(r_ell2_0(6, :)) mean(r_ell2_1(6,:)) mean(r_ell2_2(6, :)) mean(r_ell2_3(6, :)) mean(r_ell2_4(6, :))]';

std_cen_ell2 = [std(c_ell2_0) std(c_ell2_1) std(c_ell2_2) std(c_ell2_3) std(c_ell2_4)]';
std_mean_ell2 = [std(ell2_0(6, :)) std(ell2_1(6,:)) std(ell2_2(6, :)) std(ell2_3(6, :)) std(ell2_4(6, :))]';
std_mean_b_ell2 = [std(ell2_b0(6, :)) std(ell2_b1(6, :)) std(ell2_b2(6, :)) std(ell2_b3(6, :)) std(ell2_b4(6, :))]';
std_median_ell2 = [std(r_0_ell2_0(6, :)) std(r_0_ell2_1(6,:)) std(r_0_ell2_2(6, :)) std(r_0_ell2_3(6, :)) std(r_0_ell2_4(6, :))]';
std_median_b_ell2 = [std(r_ell2_0(6, :)) std(r_ell2_1(6,:)) std(r_ell2_2(6, :)) std(r_ell2_3(6, :)) std(r_ell2_4(6, :))]';

%% F1_score
avg_cen_Fscore = [mean(c_F_score_0) mean(c_F_score_1) mean(c_F_score_2) mean(c_F_score_3) mean(c_F_score_4)]';
avg_mean_Fscore = [mean(F_score_0(6, :)) mean(F_score_1(6, :)) mean(F_score_2(6, :)) mean(F_score_3(6, :)) mean(F_score_4(6, :))]';
avg_mean_b_Fscore = [mean(F_score_b0(6, :)) mean(F_score_b1(6, :)) mean(F_score_b2(6, :)) mean(F_score_b3(6, :)) mean(F_score_b4(6, :))]';
avg_median_Fscore = [mean(rF_0_score_0(6, :)) mean(rF_0_score_1(6, :)) mean(rF_0_score_2(6, :)) mean(rF_0_score_3(6, :)) mean(rF_0_score_4(6, :))]';
avg_median_b_Fscore = [mean(rF_score_0(6, :)) mean(rF_score_1(6, :)) mean(rF_score_2(6, :)) mean(rF_score_3(6, :)) mean(rF_score_4(6, :))]';


std_cen_Fscore = [std(c_F_score_0) std(c_F_score_1) std(c_F_score_2) std(c_F_score_3) std(c_F_score_4)]';
std_mean_Fscore = [std(F_score_0(6, :)) std(F_score_1(6, :)) std(F_score_2(6, :)) std(F_score_3(6, :)) std(F_score_4(6, :))]';
std_mean_b_Fscore = [std(F_score_b0(6, :)) std(F_score_b1(6, :)) std(F_score_b2(6, :)) std(F_score_b3(6, :)) std(F_score_b4(6, :))]';
std_median_Fscore = [std(rF_0_score_0(6, :)) std(rF_0_score_1(6, :)) std(rF_0_score_2(6, :)) std(rF_0_score_3(6, :)) std(rF_0_score_4(6, :))]';
std_median_b_Fscore = [std(rF_score_0(6, :)) std(rF_score_1(6, :)) std(rF_score_2(6, :)) std(rF_score_3(6, :)) std(rF_score_4(6, :))]';

%% misclassification rate
avg_cen_error = [mean(c_error_0) mean(c_error_1) mean(c_error_2) mean(c_error_3) mean(c_error_4)]';
avg_mean_error = [mean(error_iter_0(6, :)) mean(error_iter_1(6, :)) mean(error_iter_2(6, :)) mean(error_iter_3(6, :)) mean(error_iter_4(6, :))]';
avg_mean_b_error = [mean(error_iter_b0(6, :)) mean(error_iter_b1(6, :)) mean(error_iter_b2(6, :)) mean(error_iter_b3(6, :)) mean(error_iter_b4(6, :))]';
avg_median_error = [mean(r_0_error_0_iter_0_0(6, :)) mean(r_0_error_0_iter_0_1(6, :)) mean(r_0_error_0_iter_0_2(6, :)) mean(r_0_error_0_iter_0_3(6, :)) mean(r_0_error_0_iter_0_4(6, :))]';
avg_median_b_error = [mean(r_error_iter_0(6, :)) mean(r_error_iter_1(6, :)) mean(r_error_iter_2(6, :)) mean(r_error_iter_3(6, :)) mean(r_error_iter_4(6, :))]';


std_cen_error = [std(c_error_0) std(c_error_1) std(c_error_2) std(c_error_3) std(c_error_4)]';
std_mean_error = [std(error_iter_0(6, :)) std(error_iter_1(6, :)) std(error_iter_2(6, :)) std(error_iter_3(6, :)) std(error_iter_4(6, :))]';
std_mean_b_error = [std(error_iter_b0(6, :)) std(error_iter_b1(6, :)) std(error_iter_b2(6, :)) std(error_iter_b3(6, :)) std(error_iter_b4(6, :))]';
std_median_error = [std(r_0_error_0_iter_0_0(6, :)) std(r_0_error_0_iter_0_1(6, :)) std(r_0_error_0_iter_0_2(6, :)) std(r_0_error_0_iter_0_3(6, :)) std(r_0_error_0_iter_0_4(6, :))]';
std_median_b_error = [std(r_error_iter_0(6, :)) std(r_error_iter_1(6, :)) std(r_error_iter_2(6, :)) std(r_error_iter_3(6, :)) std(r_error_iter_4(6, :))]';

avg_mat = [avg_cen_ell2 avg_mean_ell2 avg_median_ell2 avg_mean_b_ell2 avg_median_b_ell2;
           avg_cen_Fscore avg_mean_Fscore avg_median_Fscore avg_mean_b_Fscore avg_median_b_Fscore;
           avg_cen_error avg_mean_error avg_median_error avg_mean_b_error avg_median_b_error];

avg_mat = round(avg_mat, 3);
