%% synthetic data simulation

% theta ture
p = 200; K = 5;
sigma = zeros(p,p);
for i = 1:p
    for k = 1:p
        sigma(i,k) = 0.5^(abs(i-k));
    end
end  
beta = zeros(p,K);
mu = zeros(p,K);
for k = 1:K
    beta(2*k-1,k)=1.6;
    beta(2*k,k) = 1.6;
    mu(:,k) = sigma * beta(:,k);
end
theta_true = beta - beta(:, 1);
theta_true(:, 1) = [];

n = 200; % replication number

%% System I
values = linspace(0.5, 2, 10);
T = 20;
for i = 1:100
    i
    [train, valid, test] = generate_data_multi(10000, p, 5);
    data_normal = data_with_Byzantine(train, valid, test, 5, 50, 0); % System I
    data_byzantine = data_with_Byzantine(train, valid, test, 5, 50, 5); % System II with 5 Byzantine machines

    [c_error(i,:), c_ell_2(i,:), c_F_score(i,:)] = msda_cen(data, K, values, theta_true); % centralized MSDA
    [d_error_iter(:, i), d_ell_2(:, i), d_F_score(:, i)] = mean_valid_msda(data, K, T, values, theta_true); % 
    [md_error_iter(:, i), md_ell_2(:, i), md_F_score(:, i)] = median_valid_msda(data, K, T, values, theta_true);
end

error_iter = mean(d_error_iter, 2);
ell2_iter = mean(d_ell_2, 2);
F_score_iter = mean(d_F_score, 2);

msda_error = mean(c_error, 1);
msda_ell = mean(c_ell_2, 1);
msda_F_score = mean(c_F_score, 1);

m_error_iter = mean(md_error_iter, 2);
m_ell2_iter = mean(md_ell_2, 2);
m_F_score_iter = mean(md_F_score, 2);




