%% synthetic data simulation

% theta ture
p = 200; K = 5;
sigma = zeros(p,p);
for i = 1:p
    for k = 1:p
        sigma(i,k) = 0.5^(abs(i-k));
    end
end  
beta = zeros(p,K);
mu = zeros(p,K);
for k = 1:K
    beta(2*k-1,k)=1.6;
    beta(2*k,k) = 1.6;
    mu(:,k) = sigma * beta(:,k);
end
theta_true = beta - beta(:, 1);
theta_true(:, 1) = [];

[train, valid, test] = generate_data_multi(10000, p, 5); % generate training set with size 10,000, validation set and test set
data_normal = data_with_Byzantine(train, valid, test, 5, 50, 0); % System I with 50 machines
data_byzantine = data_with_Byzantine(train, valid, test, 5, 50, 5); % System II with 5 Byzantine machines (alpha = 0.1)

[c_error(i,:), c_ell_2(i,:), c_F_score(i,:)] = msda_cen(data_normal, K, values, theta_true); % centralized MSDA
[d_error_iter(:, i), d_ell_2(:, i), d_F_score(:, i)] = mean_valid_msda(data_normal, K, T, values, theta_true); % Mean-DSLDA
[md_error_iter(:, i), md_ell_2(:, i), md_F_score(:, i)] = median_valid_msda(data_byzantine, K, T, values, theta_true); % Median-DSLDA




