function [train, valid, test, theta_true] = generate_data_multi(N, p, K)
   nk = N/K;
   sigma = zeros(p,p);
   for i = 1:p
      for k = 1:p
         sigma(i,k) = 0.5^(abs(i-k));
      end
   end  
   beta = zeros(p,K);
   mu = zeros(p,K);


   for k = 1:K
      beta(2*k-1,k)=1.6;
      beta(2*k,k) = 1.6;
      mu(:,k) = sigma * beta(:,k);
   end
   theta_true = beta - beta(:, 1);
   theta_true(:, 1) = [];

   X = [];
   Y = [];
   for k = 1:K
      X = [X; mvnrnd(mu(:,k), sigma, nk)]; %X(1:75,:) = X1
      Y = [Y; ones(nk, 1)*k];
   end

   % valid set, size = 1000
   valid_X = [];
   valid_Y = [];
   for k = 1:K
       valid_X = [valid_X; mvnrnd(mu(:,k), sigma, 1000/K)];
       valid_Y = [valid_Y; ones(1000/K, 1)*k];
   end
   valid{1, 1} = valid_X;
   valid{1, 2} = valid_Y;

   % test set, size = 1000
   test_X = [];
   test_Y = [];
   for k = 1:K
       test_X = [test_X; mvnrnd(mu(:,k), sigma, 1000/K)];
       test_Y = [test_Y; ones(1000/K, 1)*k];
   end
   test{1, 1} = test_X;
   test{1, 2} = test_Y;

   index_rand = randsample(1:N, N);
   train{1,1} = X(index_rand, :);
   train{1,2} = Y(index_rand, :);
end