function [error_c, ell_c, F_score_c] = msda_cen(data, K, values, theta_true)
    %data = data_1;
    M = size(data, 1) - 2; % number of machines of training set
    test_X = data{M+2, 1};  %last one : test dataset
    test_Y = data{M+2, 2};
    valid_X = data{M+1, 1};
    valid_Y = data{M+1, 2};
    p = size(test_X, 2);
    

    %compute total covariance matrix and mean
    mu_hat = zeros(p, K);
    X_t = data{1,1};
    Y_t = data{1,2};
    for m = 2:M
        X_t = [X_t; data{m,1}];
        Y_t = [Y_t; data{m,3}];
    end
    cov_class = zeros(p, p);
    for k = 1:K
        ind_k = find(Y_t == k);
        X_class = X_t(ind_k,:);
        mu_hat(:,k) = mean(X_class, 1)';
        pi_hat(k) = size(X_class,1);
        cov_class = cov_class + size(X_class,1) * cov(X_class);
    end
    Sigma = cov_class/size(X_t,1);
    pi_hat = pi_hat/sum(pi_hat);
    delta_hat = mu_hat - mu_hat(:,1);
    delta_hat(:,1) = [];

    % compute centralized MSDA estimator
    for i = 1:length(values)
        lambda = values(i);
        % blockwise coordinate descent for updating theta
        iter = 0;
        theta_update = zeros(p, K-1);
        theta_bar = zeros(p, K-1);
        while iter < 100
                dif = 0;
                for j = 1 : p
                    theta_bar = delta_hat(j,:)/Sigma(j,j) - Sigma(j,:) * theta_update + Sigma(j,j) .* theta_update(j,:);
                    theta_tmp = theta_update(j,:);
                    bar_norm = norm(theta_bar, 2);
                    v = bar_norm - lambda/Sigma(j,j);
                    if v>0
                        theta_update(j,:) = theta_bar .* (v/bar_norm);
                    else
                        theta_update(j,:) = zeros(1,K-1);
                    end
                    d = theta_update(j,:) - theta_tmp;
                    dif = max(dif, max(abs(d)));
                end
                iter = iter + 1;
                if dif < 1e-5
                    break
                end
        end

        theta_CV{i} = theta_update;
        theta_choose = [zeros(p, 1) theta_update];
        tpred_value = bayes_value(valid_X, theta_choose, mu_hat, pi_hat, K);
        [max_a, index] = max(tpred_value');
        index = index';
        error_cv(i) = 1 - mean(index == valid_Y);
    end
    theta_cen = theta_CV{find(error_cv == min(error_cv))};
    % compute error
    theta_choose = [zeros(p, 1) theta_cen];
    tpred_value = bayes_value(test_X, theta_choose, mu_hat, pi_hat, K);
    [max_a, index] = max(tpred_value');
    index = index';
    error_c = 1 - mean(index == test_Y);
    ell_c = avg_ell2(theta_cen, theta_true);
    F_score_c = F1_score(2*K, theta_cen);

end