# README: Refining Dual Spectral Sparsity in Transformed Tensor Singular Values

This package provides a minimal MATLAB implementation of the proposed ADMM-based tensor completion algorithm using $\ell_p(S_q)$ regularization, as used in the experiments on the Salinas A dataset.

## Directory Overview

```
.
├── runExpSalinas.m                    % Entry script to reproduce experiments
├── f_ntc_LpSq_ADMM_dct.m             % Core ADMM solver for Lp(Sq) minimization
├── HelperFunctions/                  % Utility routines (e.g., transform, metrics)
└── SalinasA_corrected_83x86x204.mat  % Hyperspectral image tensor used in experiments
```

## Environment

* MATLAB/Octave or later
* No external dependencies required
* Tested on macOS systems

## Usage

To reproduce the Salinas A completion results:

1. Launch MATLAB and navigate to this directory.

2. Execute the main experiment script:

```matlab
runExpSalinas
```

3. The script will:

   * Load the Salinas A tensor,
   * Randomly mask entries according to a sampling ratio,
   * Call the ADMM solver using $\ell_p(S_q)$ regularization,
   * Report PSNR and SSIM of the recovered tensor.

## Code Components

* `f_ntc_LpSq_ADMM_dct.m`: Implements the ADMM solver with weighted $\ell_{1/2}$-based approximation of the $\ell_p(S_q)$ quasi-norm. Operates in the DCT-transformed domain.
* `HelperFunctions/`: Includes helper routines for:

  * Forward/inverse DCT transform along the 3rd mode
  * Random binary masking
  * Computing PSNR and SSIM

## Data

* `SalinasA_corrected_83x86x204.mat`: Preprocessed hyperspectral image with 204 spectral bands. Commonly used in tensor recovery benchmarks.

## Notes

* Hyperparameters $(p, q)$ are selected via grid search and set within the script.
* The DCT transform is used as the default spectral basis.


