%addpath 'YOUR_PLUGINS\\eeglab2021.1'; eeglab;

EEG.etc.eeglabvers = '2021.1';

% Notice: eeglab take char array as input, NOT string, /////wtf design
srcpath = convertStringsToChars("BCI_Dataset\\ssvep\\raw\\");
destpath = convertStringsToChars("BCI_Dataset\\ssvep\\ref\\");
for num = 1:11 % 1:11
    n_str = sprintf("%03d", num);
    for cate = 0:4 % 0:4
        fname = sprintf("T%s%c.set", n_str, char(97 + cate));
        fname = convertStringsToChars(fname);
        % setpath = sprintf("BPF\\%s", fname);
        % if ~isfile(setpath)
        %      disp(setpath + " not exist");
        % end

        onlybrain %%
        EEG = pop_loadset(fname, srcpath);
        data_projected = EEG.icaweights * EEG.icasphere * EEG.data;
        inv_weight_mat = EEG.icawinv;
        [ic_p, ic_label] = max(EEG.etc.ic_classification.ICLabel.classifications, [], 2);
        for i = EEG.nbchan:-1:1
            if not (ic_label(i) == 1)
                data_projected(i,:) = [];
                inv_weight_mat(:,i) = [];
            end
        end
        ica_transform = inv_weight_mat * data_projected;
        EEG.data = ica_transform;
        EEG = pop_saveset(EEG, fname, destpath);
        EEG = eeg_checkset(EEG);
    end
end