"""
LapBoost: Semi-Supervised XGBoost with LapTAO
=============================================

LapBoost is a comprehensive semi-supervised learning framework that combines 
XGBoost's gradient boosting with LapTAO's graph-based regularization to leverage 
both labeled and unlabeled data for improved predictive performance.

Key Features
-----------
- Graph Laplacian Tree Alternating Optimization (LapTAO)
- Confidence-based pseudo-labeling pipeline
- XGBoost integration with sample weighting
- Iterative co-training strategies

Author: Anonymous Team
License: MIT
"""

__version__ = "1.0.0"
__author__ = "Anonymous Team"
__email__ = "contact@Anonymous.com"
__license__ = "MIT"

# Import main classes for easy access
from lapboost.core.model import LapBoost, LapBoostClassifier, LapBoostRegressor
from lapboost.core.iterative import IterativeLapBoostClassifier, IterativeLapBoostRegressor

# Convenience function for quick import
def create_classifier(**kwargs):
    """
    Create a LapBoostClassifier with sensible defaults.
    
    Parameters
    ----------
    **kwargs : dict
        Parameters to override defaults
        
    Returns
    -------
    LapBoostClassifier
        A ready-to-use classifier
    """
    return LapBoostClassifier(**kwargs)

def create_regressor(**kwargs):
    """
    Create a LapBoostRegressor with sensible defaults.
    
    Parameters
    ----------
    **kwargs : dict
        Parameters to override defaults
        
    Returns
    -------
    LapBoostRegressor
        A ready-to-use regressor
    """
    return LapBoostRegressor(**kwargs)
