"""
Visualization tools for LapBoost models.

This module contains utilities for visualizing LapBoost models,
graphs, confidence distributions, and performance metrics.
"""

from lapboost.visualization.plots import (
    plot_confidence_distribution,
    plot_graph_structure,
    plot_learning_curves,
    plot_decision_boundary
)

__all__ = [
    "plot_confidence_distribution",
    "plot_graph_structure",
    "plot_learning_curves", 
    "plot_decision_boundary"
]
