"""
Core modules for LapBoost implementation.

This package contains the primary algorithms and model implementations for LapBoost,
including base models, graph construction, optimization, and iterative co-training components.
"""

from lapboost.core.model import LapBoost, LapBoostClassifier, LapBoostRegressor
from lapboost.core.graph import GraphConstructor, GraphLaplacian
from lapboost.core.optimization import ObliqueTree, LapTAO
from lapboost.core.iterative import (
    IterativeLapBoostBase,
    IterativeLapBoostClassifier,
    IterativeLapBoostRegressor
)

__all__ = [
    # Base models
    "LapBoost", 
    "LapBoostClassifier", 
    "LapBoostRegressor",
    
    # Graph construction
    "GraphConstructor",
    "GraphLaplacian",
    
    # Optimization
    "ObliqueTree",
    "LapTAO",
    
    # Iterative components
    "IterativeLapBoostBase",
    "IterativeLapBoostClassifier",
    "IterativeLapBoostRegressor"
]
