import os
import time

from utils import root_dir


def main():
    experiments = [
        {"blackbox": "resnet34", "whitebox": "resnet18", "subset_size": 300, "n_attack_samples": 30, "num_epochs": 100, "dataset": "cifar10", "experiments": 30},
        {"blackbox": "resnet50", "whitebox": "resnet18", "subset_size": 600, "n_attack_samples": 200, "num_epochs": 150, "dataset": "cifar10", "experiments": 7},
        {"blackbox": "resnet101", "whitebox": "resnet18", "subset_size": 600, "n_attack_samples": 300, "num_epochs": 200, "dataset": "cifar10", "experiments": 20},
        {"blackbox": "resnet34", "whitebox": "lipschitz_cnn", "subset_size": 300, "n_attack_samples": 30, "num_epochs": 100, "dataset": "cifar10", "experiments": 30},
        {"blackbox": "resnet18", "whitebox": "lipschitz_cnn", "subset_size": 300, "n_attack_samples": 30, "num_epochs": 60, "dataset": "cifar10", "experiments": 30},
    ]

    for iteration in range(30):
        for exp in experiments:
            if iteration > exp["experiments"]:
                break

            exp_name = f'{exp["blackbox"]}_{exp["whitebox"]}_subset{exp["subset_size"]}_n_attack_samples{exp["n_attack_samples"]}_epochs{exp["num_epochs"]}_{iteration}.txt'
            run_args = [
                f"PYTHONPATH={root_dir} python test_code.py",
                f'--blackbox-model {exp["blackbox"]}',
                f'--whitebox-model {exp["whitebox"]}',
                f'--subset-size {exp["subset_size"]}',
                f'--n-attack-samples {exp["n_attack_samples"]}',
                f'--num-epochs {exp["num_epochs"]}',
                f'--dataset-name {exp["dataset"]}'
            ]
            print(exp_name)
            print(run_args)

            os.system(" ".join(run_args))

            try:
                os.rename(root_dir / "log_experiments_results.txt", root_dir / f"experiments/{exp_name}")
            except OSError:
                print("Unable to rename file :C")

            try:
                os.remove(root_dir / "log_experiments_results.txt")
            except OSError:
                print("Unable to rename file :C")
            time.sleep(1)


if __name__ == '__main__':
    main()
