### ICLR 2025 Submission 5953

This README provides detailed instructions on setting up the environment, accessing data, and running the baseline and UniCAD models to ensure that our experimental results can be reproduced accurately.

## Data Access

Our experiments use datasets available at:

[https://github.com/Minqi824/ADBench/tree/main/adbench/datasets/Classical](https://github.com/Minqi824/ADBench/tree/main/adbench/datasets/Classical)

Please download the datasets from the above link before proceeding with the experiments.

## Environment Setup

To replicate our experimental environment, please follow these steps:

1. Install Python 3.9 using the provided script:
    ```
    bash scripts/install-py3.9.sh
    ```
2. Install the required development dependencies:
    ```
    bash scripts/install-dev.sh
    ```
3. Activate the virtual environment:
    ```
    source .venv/bin/activate
    ```

## Running Baseline Models

To run the baseline models, execute the following commands:

1. For basic baseline models:
    ```
    python baselines/run_adbench.py
    ```
2. For cluster-based anomaly detection:
    ```
    python baselines/run_cluster-based.py
    python baselines/run_dcfod.py
    ```

## Running UniCAD Model

To run the UniCAD model, use the following command:

```
python unicad/run.py
```