import torch
from torch.utils.data import DataLoader, Dataset
import numpy as np

class CustomDataset(Dataset):
    def __init__(self, data):
        self.data = torch.tensor(data, dtype=torch.float32)

    def __len__(self):
        return len(self.data)

    def __getitem__(self, idx):
        return self.data[idx]
    
class RowScaler:
    def __init__(self, order=2):
        self.order = order

    def fit(self, X):
        self.row_sums = np.linalg.norm(X, ord=self.order, axis=1)
        return self

    def transform(self, X):
        return X / self.row_sums[:, np.newaxis]

    def fit_transform(self, X):
        self.fit(X)
        return self.transform(X)