#!/bin/bash

# Get the user's home directory
USER_HOME=$(eval echo ~)

# Download Python 3.9.5
wget -c https://www.python.org/ftp/python/3.9.5/Python-3.9.5.tgz

# Extract the downloaded file
tar -xvf Python-3.9.5.tgz

# Create a directory for the installation
mkdir -p $USER_HOME/python

# Enter the Python source directory
cd Python-3.9.5

# Configure the installation parameters
./configure --prefix="$USER_HOME/python/"

# Compile
make

# Install
make install

# Add Python to the environment variable
echo "# Python3/pip3 environment variable" >> $USER_HOME/.bashrc
echo "export PATH=$USER_HOME/python/bin:\$PATH" >> $USER_HOME/.bashrc

# Apply the changes to the environment variables
source $USER_HOME/.bashrc

# Test the installation
python3 -V
pip3 -V

# Confirmation message
echo "Python 3.9.5 installation complete, path: $USER_HOME/python"
echo "Please confirm the correct Python and Pip versions are displayed in the above output."

