from itertools import product
import numpy as np
import pandas as pd
from sklearn.linear_model import LogisticRegression

# import os
# import pickle as pkl


def generate_grid_gmm_samples(seed, n=50, sqrt_mixtures=5, target=None):

    k = sqrt_mixtures
    mu = list(product(
        np.arange(-(k // 2), (k + 1) // 2),
        np.arange(-(k // 2), (k + 1) // 2)
    ))
    sigma = 1

    mixtures = np.random.multinomial(n, [1 / k ** 2] * k ** 2, size=1)[0]

    data = []
    for mix in np.arange(k ** 2):
        data.append(np.random.normal(mu[mix], sigma, size=(mixtures[mix], 2)))

    samples = np.concatenate(data, 0)
    samples = pd.DataFrame(samples)

    if target:
        beta_ = np.random.randn(2)
        beta_[1] = 0
        intercept = 1
        logits = samples @ beta_.T
        target = logits + intercept > 0
        beta = np.concatenate([[intercept], beta_])
    else:
        beta = None

    return samples, mu, sigma, target, beta


def generate_triangle(seed, n=1000, target=None):

    np.random.seed(seed)

    samples = np.random.uniform(low=0, high=1, size=(int(n * 2.1), 2))
    samples = samples[samples[:, 0] + samples[:, 1] < 1][:n]
    samples = pd.DataFrame(samples)

    if target:
        beta_ = np.random.randn(2)
        beta_[1] = 0
        intercept = 1
        logits = samples @ beta_.T
        target = logits + intercept > 0

        beta = np.concatenate([[intercept], beta_])

        # target = np.random.uniform(size=(len(probs))) < probs

        # import matplotlib.pyplot as plt
        # import seaborn as sns

        # sns.kdeplot(
        #     samples.values[:1000, 0],
        #     y=samples.values[:1000, 1],
        #     fill=False,
        #     hue=target[:1000],
        # )
        # plt.savefig("output/test.png", format="png")
    else:
        beta = None

    return samples, target, beta
