import numpy as np
import pandas as pd
from scipy.stats import multivariate_normal
import random


def sample_uniform(
    df_,
    n_s,
    seed,
    args,
    scaler=None,
    mu_gmm=None,
    sigma_gmm=None,
    beta=None,
    target=None,
    **kwargs,
):

    random.seed(seed)

    if mu_gmm:
        df = scaler.inverse_transform(df_)
    else:
        df = df_

    if target:
        min_ = (df[:, :-1].min() - 1e-3) * 1.01
        max_ = df[:, :-1].max() * 1.01
    else:
        min_ = (df.min().min() - 1e-3) * 1.01
        max_ = df.max().max() * 1.01
    dim = df.shape[1]

    data = np.random.uniform(low=min_, high=max_, size=(n_s, dim))
    # data = data[(data[:, 0] + data[:, 1]) > 1][:n_s]

    if mu_gmm:
        pdfs = [
            multivariate_normal.pdf(data[:, : dim - target], mu_i, sigma_gmm)
            for mu_i in mu_gmm
        ]
        log_prob_gmm = np.log(np.stack(pdfs).mean(0) + 1e-8)
        if target:
            target_ = data[:, -1] > ((max_ - min_) / 2 + min_)
            logits = data[:, :-1] @ beta[1:].T + beta[0]
            # log_p1 = -np.log(1 + np.exp(-logits))
            # log_p0 = -np.log(1 + np.exp(logits))
            log_p1 = np.log((logits > 0) * (1 - 2e-12) + 1e-12)
            log_p0 = np.log((logits < 0) * (1 - 2e-12) + 1e-12)
            log_prob_gmm += log_p1 * target_ + log_p0 * (1 - target_)
        log_weights = log_prob_gmm - np.log(1 / (max_ - min_) ** 2) - np.log(0.5)
    elif args.fn_csv == 'triangle':
        log_weights = np.zeros(n_s)
        log_weights -= np.log(1 / (max_ - min_) ** 2)
        log_weights[(data[:, 0] + data[:, 1]) < 1] += np.log(2 / (max_ - min_) ** 2)
        log_weights[(data[:, 0] + data[:, 1]) >= 1] += np.log(1e-10)
        if target:
            raise NotImplementedError

    if mu_gmm:
        synth_data = pd.DataFrame(scaler.transform(data))
        if target:
            synth_data.iloc[:, -1] = target_ * 1.0
    else:
        synth_data = pd.DataFrame(data)

    return synth_data, log_weights
