import random
import ast
import re
import os
import torch.multiprocessing as mp
from tqdm import tqdm
import json
import numpy as np
import openai

def parse_text(text):
    parsed_list = []
    match = re.search(r"\[(.*?)\]", text, re.S)
    if match:
        list_content = "[" + match.group(1) + "]"
        try:
            raw_list = ast.literal_eval(list_content) 
            parsed_list.extend([s for s in raw_list if not re.search(r"[\"“”‘’]", s)])
        except (SyntaxError, ValueError):
            print("❌")
    
    numbered_sentences = re.findall(r"(\d+)\.\s*(.*)", text)
    for _, sentence in numbered_sentences:
        if not re.search(r"[\"“”‘’]", sentence):
            parsed_list.append(sentence)
    return parsed_list

def generate_and_save(descs_part, process_id, save_dir):
    samples = [
    "After hearing the previous speaker’s explanation, he questioned it in a skeptical tone.",
    "Someone just told a lighthearted joke, which made her respond with a teasing tone.",
    "The other party suddenly changed their tone to make a request, and she responded tactfully after a brief hesitation.",
    "Midway through, the speaker became emotional, making the discussion more tense.",
    "In the summary phase, he outlined the key points one by one and emphasized the core stance again.",
    "After someone expressed strong dissatisfaction, she actively supported their opinion and became more direct in her speech.",
    "Following a moment of silence in the discussion, he tentatively asked for a reconsideration of a part of the content.",
    "After the previous speaker made a compromise, they tried to reconcile earlier disagreements with a firmer tone.",
    "Shortly after the conversation began, the other party attempted an explanation from a different perspective, speaking more calmly.",
    "After multiple rounds of heated debate, she attempted to introduce a new topic with a noticeably more aggressive expression.",
    "After hearing an affirmative statement, he presented a different viewpoint with a more cautious attitude.",
    "After a lengthy statement, he asked for a reconsideration of some content, noticeably slowing his speech.",
    "After a proposal was rejected, he launched a rebuttal from a different angle, revealing unease in his tone.",
    "Following an intense round of discussion, she suddenly began to question the previous conclusion, becoming more direct.",
    "After someone told a relaxed anecdote, they began to review earlier highlights, with a more relaxed tone.",
    "After someone expressed strong dissatisfaction, the other party tried to explain from another perspective in a firmer tone.",
    "After the previous speaker made a compromise, he asked for a reconsideration of some content, with a more direct style.",
    "Shortly after the conversation began, she suddenly began questioning the earlier conclusion, revealing unease in her words.",
    "After a heated round of debate, he presented a different perspective, noticeably slowing his speech.",
    "After hearing an affirmative statement, she proactively supported the other party’s view, her tone becoming calmer.",
    "After a lengthy statement, they began to review the earlier key points, with a tentative tone.",
    "After a proposal was just rejected, she tried to introduce a new topic, speaking with greater firmness.",
    "Someone had just told a humorous story, and they tried to reconcile previous disagreements, appearing more cautious.",
    "After several rounds of repeated argument, the other party attempted to explain from a different angle, their speech showing emotional fluctuation.",
    "Following a brief silence, he launched a rebuttal from another direction, with a noticeably more aggressive expression.",
    "After someone told a relaxed anecdote, she tried to introduce a new topic, and the overall tone became more relaxed.",
    "After someone expressed strong dissatisfaction, they tried to reconcile previous disagreements, with a calmer tone.",
    "After a proposal was just rejected, he presented a different viewpoint, becoming more direct in expression.",
    "After a lengthy statement, she proactively supported the other party's opinion, noticeably slowing her speech.",
    "After the previous speaker made a compromise, they began to review earlier points, with unease in their tone.",
    "Following a round of intense discussion, he launched a rebuttal from another direction, appearing more cautious.",
    "After hearing an affirmative statement, she suddenly began to question the previous conclusion, with greater firmness in tone.",
    "Shortly after the conversation began, they tried to reconcile earlier disagreements, their speech showing emotional fluctuation.",
    "After several rounds of repeated argument, he asked for reconsideration of part of the content, becoming more direct.",
    "After a brief silence, she proactively supported the other party’s opinion, and the overall tone became more relaxed.",
    "After someone expressed strong dissatisfaction, the other party tried to explain from another perspective, noticeably slowing the pace of speech.",
    "After a lengthy statement, he attempted to introduce a new topic, with a noticeably more aggressive expression.",
    "After someone told a relaxed anecdote, they began to review earlier points, speaking more firmly.",
    "After a proposal was just rejected, he asked for a reconsideration of some content, his tone becoming calmer.",
    "After the previous speaker made a compromise, she proactively supported the other’s opinion, with a tentative tone.",
    "Shortly after the conversation began, she presented a different viewpoint, with a more cautious attitude.",
    "After an intense round of discussion, he launched a rebuttal from another direction, expressing himself more directly.",
    "After hearing an affirmative statement, they tried to reconcile earlier disagreements, with unease in their tone.",
    "Someone had just told a humorous story, and the other party tried to explain from a different angle. The overall tone became more relaxed.",
    "After several rounds of argument, he attempted to introduce a new topic, and his tone became more even.",
    "Following a brief silence, she suddenly began to question the previous conclusion, her speech showing emotional fluctuation.",
    "After a proposal was just rejected, they began to review earlier key points, with a noticeably more aggressive expression.",
    "Someone had just expressed strong dissatisfaction, and she tried to introduce a new topic, appearing more cautious.",
    "Shortly after the conversation began, she proactively supported the other party’s opinion, noticeably slowing her speech.",
    "After the previous speaker made a compromise, he launched a rebuttal from another direction, with greater firmness in tone.",
    "After a lengthy statement, they tried to reconcile earlier disagreements, expressing themselves more directly.",
    "After hearing an affirmative statement, she suddenly began to question the previous conclusion, with unease in her tone.",
    "After a round of intense discussion, the other party attempted to explain from a different perspective, with a more even tone.",
    "After several rounds of argument, she proactively supported the other party’s opinion, speaking tentatively.",
    "After a proposal was just rejected, he presented a different viewpoint, with a more relaxed attitude.",
    "Someone had just told a humorous story, and she attempted to introduce a new topic, with a noticeably more aggressive expression.",
    "Following a brief silence, he launched a rebuttal from another direction, his speech showing emotional fluctuation.",
    "After someone expressed strong dissatisfaction, they began to review earlier points, appearing more cautious.",
    "After a lengthy statement, he asked for a reconsideration of part of the content, with greater firmness in tone.",
    "After hearing an affirmative statement, she proactively supported the other party’s opinion, expressing herself more directly.",
    "Someone had just told a humorous story, and she presented a different viewpoint, revealing unease in her words.",
    "Shortly after the conversation began, they tried to reconcile earlier disagreements. The overall tone became more relaxed.",
    "After several rounds of repeated arguments, the other party attempted to explain from a different angle, noticeably slowing their speech.",
    "After an intense round of discussion, he tried to introduce a new topic, with a noticeably more aggressive tone.",
    "After a proposal was just rejected, she suddenly began to question the previous conclusion, and her tone became calmer.",
    "Someone had just told a humorous story, and they began to review earlier key points, with a tentative tone.",
    "After the previous speaker made a compromise, she proactively supported the other’s opinion, with emotional fluctuations in her voice.",
    "After someone expressed strong dissatisfaction, he launched a rebuttal from another direction, appearing more cautious.",
    "Following a brief silence, she tried to introduce a new topic, expressing herself more directly.",
    "After a lengthy statement, they tried to reconcile earlier disagreements, with greater firmness in tone.",
    "After hearing an affirmative statement, he presented a different viewpoint, and his tone became calmer.",
    "Shortly after the conversation began, they began to review earlier points, revealing unease in their words.",
    "Someone had just told a humorous story, and she suddenly began to question the previous conclusion, with a noticeably more aggressive tone.",
    "After a proposal was just rejected, the other party attempted to explain from a different angle. The overall tone became more relaxed.",
    "After several rounds of repeated argument, he asked for reconsideration of part of the content, appearing more cautious.",
    "After an intense round of discussion, she proactively supported the other party’s opinion, noticeably slowing her speech.",
    "After hearing an affirmative statement, they tried to reconcile earlier disagreements, expressing themselves more directly.",
    "After a lengthy statement, she presented a different viewpoint, and her tone became calmer.",
    "The previous speaker made a compromise, and he tried to introduce a new topic, revealing unease in his words.",
    "Someone had just expressed strong dissatisfaction, and she launched a rebuttal from another direction, with a noticeably more aggressive tone.",
    "Shortly after the conversation began, they began to review earlier key points, speaking more firmly.",
    "Someone had just told a humorous story, and she proactively supported the other party’s opinion, with a tentative tone.",
    "After a proposal was just rejected, the other party attempted to explain from a different perspective, their speech showing emotional fluctuation.",
    "After an intense round of discussion, she presented a different viewpoint, expressing herself more directly.",
    "After hearing an affirmative statement, he launched a rebuttal from another direction, with a more relaxed attitude.",
    "After several rounds of repeated argument, she attempted to introduce a new topic, and her tone became more even.",
    "Following a brief silence, they began to review earlier points, speaking more firmly.",
    "After someone expressed strong dissatisfaction, she suddenly began to question the previous conclusion, noticeably slowing her speech.",
    "Shortly after the conversation began, she asked for a reconsideration of part of the content, with a noticeably more aggressive expression.",
    "Someone had just told a humorous story, and he presented a different viewpoint, appearing more cautious.",
    "After a lengthy statement, she proactively supported the other party’s opinion, with unease in her words.",
    "After an intense round of discussion, they tried to reconcile earlier disagreements, expressing themselves more directly.",
    "After a proposal was just rejected, she attempted to introduce a new topic, and her tone became calmer.",
    "The previous speaker made a compromise, and he launched a rebuttal from another direction, with a tentative tone.",
    "After hearing an affirmative statement, she suddenly began to question the previous conclusion, and the overall tone became more relaxed.",
    "After several rounds of repeated argument, they began to review earlier points, their speech showing emotional fluctuation.",
    "After a lengthy statement, the other party attempted to explain from another angle, expressing themselves more directly.",
    "Someone had just told a humorous story, and she presented a different viewpoint, and her tone became calmer.",
    "Following a brief silence, he asked for a reconsideration of some content, with greater firmness in tone.",
    "After hearing an affirmative statement, she proactively supported the other party’s opinion, expressing herself more directly.",
]
    openai.api_key = os.getenv("OPENAI_API_KEY")
    temp_file = os.path.join(save_dir, f"context_{process_id}.tsv")
    with open(temp_file, "w", encoding="utf-8") as wf:
        for i, desc in enumerate(tqdm(descs_part, desc=f"Process-{process_id}")):
            try:
                rand_idxs = [
                    random.randint(0, len(samples)-1),
                    random.randint(0, len(samples)-1),
                    random.randint(0, len(samples)-1),
                    random.randint(0, len(samples)-1),
                ]
                prompt = f"""
You are an expert in dialogue content modeling. Please generate a series of **dialogue scenario descriptions that contain only “dialogue content and context.”** Note that the generated content **must not include or imply any of the following information**:
- Interpersonal relationships or character attributes (e.g., age, gender, identity, occupation, personality, social status, cultural background, physical or emotional states)
- Dialogue environment or external factors (e.g., quiet/noisy, meeting room/in-car, face-to-face/phone, surveillance presence, time pressure, etc.)
- Non-verbal interaction information (e.g., gestures, facial expressions, eye contact, physical distance, microphone usage, audience feedback, etc.)

You should focus only on the following elements of “dialogue content and context”:
- **Contextual background**: emotional atmosphere or prior events influencing the dialogue (e.g., someone just got angry, someone just told a joke)
- **Dialogue topic**: e.g., serious/lighthearted, work/entertainment, public/private
- **Speech intention**: purposes such as request, rebuttal, comfort, questioning, threat, acting spoiled, etc.
- **Emotional contagion**: when a speaker’s expression changes due to others’ emotions
- **Turn-taking phase**: different phases such as first turn, mid-conversation response, topic shift, or summary statement

Please output **15 English-language dialogue content and context scene descriptions**, each as one sentence. The scenarios should be realistic, specific, and diverse, and each should reflect one or more typical features of “dialogue content and context.”

Format the final output as a Python list of strings, such as:
[
    "{samples[rand_idxs[0]]}",
    "{samples[rand_idxs[1]]}",
    "{samples[rand_idxs[2]]}",
    ...
]
"""
                response = openai.ChatCompletion.create(
                    model="gpt-4o",
                    messages=[
                        {"role": "user", "content": prompt},
                    ],
                    temperature=random.randint(50, 150) / 100.0,
                )
                response = response.choices[0].message.content
                parsed_list = parse_text(response)
                for line in parsed_list:
                    print(line.strip(), file=wf, flush=True)
            except Exception as e:
                print(e)

def merge_files(save_dir, final_output):
    lines_seen = set()
    with open(final_output, "w", encoding="utf-8") as wf:
        for file in sorted(os.listdir(save_dir)):  
            if file.startswith("context_") and file.endswith(".tsv"):
                try:
                    with open(os.path.join(save_dir, file), "r", encoding="utf-8") as rf:
                        for line in rf:
                            if line not in lines_seen:
                                wf.write(line)
                                lines_seen.add(line)
                except:
                    continue
                os.remove(os.path.join(save_dir, file))

def main():
    import time
    total_requests = 1500 
    num_processes = 32  
    save_dir = "./datas/scripts/"
    final_output = os.path.join(save_dir, "final_context.tsv")

    os.makedirs(save_dir, exist_ok=True)

    mp.set_start_method("spawn", force=True)  
    processes = []
    
    requests_per_process = total_requests // num_processes  
    for process_id in range(num_processes):
        start_idx = process_id * requests_per_process
        end_idx = (process_id + 1) * requests_per_process if process_id != num_processes - 1 else total_requests
        p = mp.Process(target=generate_and_save, args=(np.arange(start_idx, end_idx), process_id, save_dir))
        p.start()
        processes.append(p)

    for p in processes:
        p.join()  

    merge_files(save_dir, final_output)
    print(f"✅ {final_output}")

if __name__ == "__main__":
    main()