INPUT_HOME=$1
INPUT_TSV=$2
DEVICE=$3
REF_HOME=./pretrained_models/emogen/Emotional_Speech_Dataset/

export XDG_CACHE_HOME=./pretrained_models/util_ckpts/xdg
export TRITON_AUTOTUNE_PATH=./pretrained_models/util_ckpts/triton
export TRITON_CACHE_DIR=./pretrained_models/util_ckpts/triton
export S3PRL_CACHE=./pretrained_models/util_ckpts/s3prl
export TORCH_HOME=./pretrained_models/util_ckpts/torch
export MODELSCOPE_CACHE=./pretrained_models/util_ckpts/modelscope
export TRANSFORMERS_CACHE=./pretrained_models/util_ckpts/transformers
export HF_HOME=./pretrained_models/util_ckpts/huggingface
export G2P_CACHE=./pretrained_models/util_ckpts/g2p_cache
export NLTK_DATA=./pretrained_models/util_ckpts/nltk_cache
export SPACY_HOME=./pretrained_models/util_ckpts/spacy_cache
export HF_ENDPOINT=https://hf-mirror.com
export CUDA_VISIBLE_DEVICES=${DEVICE}
export PYTHONPATH=./pretrained_models/utils_codes/resemblyzer:./pretrained_models/fairseq_emogen/examples/celsds/infer/evaluate
export TRANSFORMERS_VERBOSITY=info
export audeer_home=./pretrained_models/util_ckpts/
export emo2vec_home=./pretrained_models/util_ckpts/emotion/emotion2vec_plus_large
export dns_home=./pretrained_models/util_ckpts/NISQA
export wavlm_home=./pretrained_models/util_ckpts/speaker
export wavlm_s3prl=./pretrained_models/util_ckpts/wavlm_large.pt

python -u \
examples/wescon/infer/data_filter/eval_inner_emo_multiprocess.py \
--tsv ${INPUT_TSV} \
--out_home ${INPUT_HOME} \
--ref_home ${REF_HOME} \
--num_workers 4
