# RELEASE THE POWERS OF PROMPT TUNING: CROSS-MODALITY PROMPT TRANSFER

## 1. Get VTAB-1K
Please follow https://github.com/ziplab/SPT

## 2. Set up the environment
```
conda create -n xmm python==3.9 pip
conda activate xmm
pip install torch==2.0.1 torchvision==0.15.2
pip install transformers==4.31.0
pip install seaborn
pip install tensorboard
pip install numpy==1.25.2
```
Open the folder as a PyCharm project is recommended after setting up.

## 3. Frozen Prompt Transfer & Projection Transfer & Attention Transfer
1. Open `main.py`
2. Modify the parameters under the `Parameters Need Your Modification` block, note that the function `train_utils.print_sys_info` determines your GPU device.
3. Run `main.py`
4. Note that you can modify the training hyperparameters in the config yaml files under the `./configs` folder.

## 4. How to calculate MMD between source prompts and target images?
Simply run `./analysis/analyzer_cross_modality.py`

## 5. Transferability
+ BASELINE-AVG_COS: modify `./transferability/baseline_main.py` line 22, variable `metric` to `COSINE_AVERAGE` and run.
+ BASELINE-MODEL_STIMULATION: modify `./transferability/baseline_main.py` line 22, variable `metric` to `MODEL_ACTIVATION` and run.
+ Gm Only: simply run `./transferability/rank_mmd_and_projection.py`
+ Gt Only: modify `./transferability/configs/UniversalProjector.yaml` line 32, variable `involve` to `False` and run `./transferability/universal_projector_main.py`
+ Gm and Gt: modify `./transferability/configs/UniversalProjector.yaml` line 32, variable `involve` to `True` and run `./transferability/universal_projector_main.py`