# from pytorch_grad_cam import GradCAM, ScoreCAM, GradCAMPlusPlus, AblationCAM, XGradCAM, EigenCAM
from pytorch_grad_cam import GradCAM
from pytorch_grad_cam.utils.image import show_cam_on_image, preprocess_image
from models.preactivate_resnet import *
from datasets import cifar10_dataloaders, cifar10_test_dataloaders
from advertorch.attacks import LinfPGDAttack, L2PGDAttack
from advertorch.context import ctx_noparamgrad
import torch.nn as nn
from  torchvision.utils import save_image 
import argparse
import os
import torch
import pdb
import numpy as np
import cv2
import tqdm
from skimage.io import imsave
import saliency.core as saliency
import PIL.Image
from matplotlib import pylab as P
from torchvision import models, transforms
from advertorch.utils import NormalizeByChannelMeanStd
import numpy as np
from models.utils import *

parser = argparse.ArgumentParser(description='Init Sparse Training Mask')
parser.add_argument('--model_dir', help='The directory load the trained models', default=None, type=str)
parser.add_argument('--best_check', action='store_true', help='best checkpoint (default: off)')
#### adv ######
parser.add_argument('--train_eps', default=8, type=float, help='epsilon of attack during training')
parser.add_argument('--train_step', default=10, type=int, help='itertion number of attack during training')
parser.add_argument('--train_gamma', default=2, type=float, help='step size of attack during training')
parser.add_argument('--train_randinit', action='store_false', help='randinit usage flag (default: on)')
parser.add_argument('--test_eps', default=8, type=float, help='epsilon of attack during testing')
parser.add_argument('--test_step', default=20, type=int, help='itertion number of attack during testing')
parser.add_argument('--test_gamma', default=2, type=float, help='step size of attack during testing')
parser.add_argument('--test_randinit', action='store_false', help='randinit usage flag (default: on)')

def reshape_transform(tensor, height=7, width=7):
    # result = tensor.reshape(tensor.size(0), 
    #     height, width, tensor.size(2))

    # Bring the channels to the first dimension,
    # like in CNNs.
    result = tensor.transpose(2, 3).transpose(1, 2)
    return result

# Boilerplate methods.
def ShowImage(im, title='', ax=None):
    if ax is None:
        P.figure()
    P.axis('off')
    P.imshow(im)
    P.title(title)

def ShowGrayscaleImage(im, title='', ax=None):
    if ax is None:
        P.figure()
    P.axis('off')
    P.imshow(im, cmap=P.cm.gray, vmin=0, vmax=1)
    P.title(title)

def ShowHeatMap(im, title, ax=None):
    if ax is None:
        P.figure()
    P.axis('off')
    P.imshow(im, cmap='inferno')
    P.title(title)

def LoadImage(file_path):
    im = PIL.Image.open(file_path)
    # im = im.resize((299, 299))
    im = np.asarray(im)
    return im

transformer = transforms.Normalize((0.485, 0.456, 0.406), (0.229, 0.224, 0.225))
def PreprocessImages(images):
    # assumes input is 4-D, with range [0,255]
    #
    # torchvision have color channel as first dimension
    # with normalization relative to mean/std of ImageNet:
    #    https://pytorch.org/vision/stable/models.html
    images = np.array(images)
    images = images/255
    images = np.transpose(images, (0,3,1,2))
    images = torch.tensor(images, dtype=torch.float32)
    images = transformer.forward(images)
    return images.requires_grad_(True)

if __name__ == '__main__':

    args = parser.parse_args()
    args.train_eps = args.train_eps / 255
    args.train_gamma = args.train_gamma / 255
    args.test_eps = args.test_eps / 255
    args.test_gamma = args.test_gamma / 255

    model = resnet18_2()
    dataset_normalization = NormalizeByChannelMeanStd(
            mean=[0.4914, 0.4822, 0.4465], std=[0.2470, 0.2435, 0.2616])
    model.normalize = dataset_normalization
    model = prune_unstructured(model, 1-0.1)
    model.cuda()
    model.eval()
    print(args.model_dir)
    path = os.path.join(args.model_dir, 'checkpoint.pth.tar')
    if args.best_check:
        path = os.path.join(args.model_dir, 'model_RA_best.pth.tar')
    checkpoint = torch.load(path, map_location = torch.device('cuda:0'))
    model.load_state_dict(checkpoint['state_dict'])

    conv_layer = model.layer4[-1].conv2
    conv_layer_outputs = {}

    def conv_layer_forward(m, i, o):
        # move the RGB dimension to the last dimension
        conv_layer_outputs[saliency.base.CONVOLUTION_LAYER_VALUES] = torch.movedim(o, 1, 3).detach().cpu().numpy()
    def conv_layer_backward(m, i, o):
        # move the RGB dimension to the last dimension
        conv_layer_outputs[saliency.base.CONVOLUTION_OUTPUT_GRADIENTS] = torch.movedim(o[0], 1, 3).detach().cpu().numpy()

    # conv_layer.register_forward_hook(conv_layer_forward)
    # conv_layer.register_backward_hook(conv_layer_backward)

    class_idx_str = 'class_idx_str'
    def call_model_function(images, call_model_args=None, expected_keys=None):
        images = PreprocessImages(images).cuda()
        target_class_idx =  call_model_args[class_idx_str]
        # pdb.set_trace()
        output = model(images)
        m = torch.nn.Softmax(dim=1)
        output = m(output).cuda()
        if saliency.base.INPUT_OUTPUT_GRADIENTS in expected_keys:
            outputs = output[:,target_class_idx].cuda()
            grads = torch.autograd.grad(outputs, images, grad_outputs=torch.ones_like(outputs))
            grads = torch.movedim(grads[0], 1, 3)
            gradients = grads.detach().cpu().numpy()
            return {saliency.base.INPUT_OUTPUT_GRADIENTS: gradients}
        else:
            one_hot = torch.zeros_like(output)
            one_hot[:,target_class_idx] = 1
            model.zero_grad()
            output.backward(gradient=one_hot, retain_graph=True)
            return conv_layer_outputs
                            

    target_layer = model.layer4[-1]
    sample = 100
    test_loader = cifar10_test_dataloaders(batch_size = sample, data_dir = 'data/cifar10')
    (input_tensor, target) = next(iter(test_loader))
    input_tensor = input_tensor.cuda()
    target = target.cuda()

    # for index, img in enumerate(input_tensor):
    #     clean_image_name = "{}_clean.svg".format(index)
    #     save_dir = os.path.join('checkpoints/raw_2', clean_image_name)
    #     save_image(img, save_dir)


    save_dir = os.path.join(args.model_dir, 'final_saliency_32')
    if args.best_check:
        save_dir = os.path.join(args.model_dir, 'best_saliency_32')

    os.makedirs(save_dir, exist_ok=True)

    #adv samples
    criterion = nn.CrossEntropyLoss()

    adversary = LinfPGDAttack(
        model, loss_fn=criterion, eps=args.test_eps, nb_iter=args.test_step, eps_iter=args.test_gamma,
        rand_init=args.test_randinit, clip_min=0.0, clip_max=1.0, targeted=False
    )

    with ctx_noparamgrad(model):
        input_adv = adversary.perturb(input_tensor, target)



    ROWS = 1
    COLS = 2
    UPSCALE_FACTOR = 10
    P.figure(figsize=(ROWS * UPSCALE_FACTOR, COLS * UPSCALE_FACTOR))

    for index, (img, target) in enumerate(zip(input_adv, target)):
        call_model_args = {class_idx_str: target.item()}
        raw_image_name = "{}_raw.png".format(index)
        image_path = os.path.join(save_dir, raw_image_name)
        save_image(img, image_path)
        im_orig = LoadImage(image_path)
        im = im_orig.astype(np.float32)
        gradient_saliency = saliency.GradientSaliency()
        vanilla_mask_3d = gradient_saliency.GetMask(im, call_model_function, call_model_args)
        # pdb.set_trace()
        vanilla_mask_grayscale = saliency.VisualizeImageGrayscale(vanilla_mask_3d)


        saliency_image_name = "{}_saliency.png".format(index)
        saliency_save_path = os.path.join(save_dir, saliency_image_name)
        imsave(saliency_save_path, vanilla_mask_grayscale)

    print("finish!")




