import pandas as pd
import sys
import re
import os



res_path = sys.argv[1]


if __name__ == '__main__':

    df = pd.read_excel(res_path)
    # df["列名"]=df.apply(lambda x:方法名(x,入参2),axis=1)

    df['file'] = df['file'].apply(lambda x: re.search('d(\d+(\.\d+)?)', x).group())

    df_mean_std = df.groupby("file").agg(['mean', 'std'])
    # s = df.groupby("file").agg('std')

    file_name = '{}_mean_std.xlsx'.format(os.path.basename(res_path))
    save_dir = './statis2'
    os.makedirs(save_dir, exist_ok=True)
    save_path = os.path.join(save_dir, file_name)
    df_mean_std.to_excel(save_path, float_format = '%.2f')