
import numpy as np

class Gaussian():

  def __init__(self, mu, var):
    self.mu = mu
    self.var = var
  
  def sample(self, n=None):
    """
    Sample n data points from the Gaussian.
    """
    return np.random.normal(self.mu, self.var, n)

class Uniform():

  def __init__(self, a, b):
    self.a = a
    self.b = b
  
  def sample(self, n=None):
    return np.random.uniform(self.a, self.b, n)
