import os
import itertools
import argparse
import numpy as np

parser = argparse.ArgumentParser()
parser.add_argument("filename")
args = parser.parse_args()

CONFIG_EXP1 = {
  'n_tasks': [50],
  'n_supp': [20],
  'n_query': [30],
  'k_supp': [5],
  'k_query': [50],
  'epochs': [150],
  'val_obs_noise': np.logspace(-3, 3, 20)
}

CONFIG_EXP2 = {
  'n_tasks': [50],
  'n_supp': [20],
  'n_query': [30],
  'k_supp': [500],
  'k_query': [50],
  'epochs': [150],
  'val_obs_noise':  np.logspace(-3, 3, 20)
}

CONFIG_EXP3 = {
  'n_tasks': [50],
  'n_supp': [200],
  'n_query': [30],
  'k_supp': [5],
  'k_query': [50],
  'epochs': [150],
  'val_obs_noise': np.logspace(-3, 3, 20)
}

CONFIG_EXP4 = {
  'n_tasks': [2, 5, 20, 50],
  'n_supp': [5, 50],
  'n_query': [30],
  'k_supp': [5, 50, 500],
  'k_query': [50],
  'epochs': [150],
  'val_obs_noise': np.logspace(-3, 3, 20)
}


COMMAND_TEMPLATE = 'python maml_sinusoid.py with '


class ConfigIterator:

  def __init__(self, conf):
    self.conf = conf
  
  def __iter__(self):
    return itertools.product(*[self.conf[key] for key in self.conf])

def generate_job_strings():
    jobs = []
    for setting in ConfigIterator(CONFIG_EXP1):
      command = COMMAND_TEMPLATE
      for i, k in enumerate(CONFIG_EXP1):
        command += "'{}={}' ".format(k, setting[i])
      command += '\n'
      jobs.append(command)
    return jobs

if __name__ == '__main__':
    jobs = generate_job_strings()
    with open(args.filename, 'w') as f:
        f.writelines(jobs)
