## Notes

* `train_xcodes_ytime.py` trains xcodes to ytime. 
* `train_classif.py` trains a classification model.
* `train_translation.py` trains translation models
* `train_zeroshot_classif.py` trains zeroshot classification models (pt2, 5 --> pt12)

### How to run:

1. To train xcodes --> ytime directly use `train_xcodes_ytime.py`. This file
    * learns an transformer encoder to map input codes in x to output time in y. 
    * includes two prediction schemes (in args). `scheme=2` follows PatchTST (urevins the time series). `scheme=1` predicts mu/std for y (default).
    By default, the code does not checkpoint. We might not want to checkpoint when experimenting. To turn checkpointing on do `--checkpoint 1`

    Run as follows:
    ```python 
    python train_xcodes_ytime.py --data-type neuropt12 --Tout 336 --cuda-id 2 --seed 2021
    ```

2. To train classification models (either baselines or ours). 

   To run EEGNet (baseline):
   ```python
   python train_classif.py --pt 2 --model-type eeg --seed 2021
   ```

   To run ours:
   ```python
   python train_classif.py --pt 2 --model-type xformer --seed 2021
   ```

3. To run translation models (either baselines or ours):

   To run MLP (baseline):
   ```python
   python train_translation.py --data-type random --seed 2021 --model-type mlptime --mode en2z
   ```

   To run ours:
   ```python
   python train_translation.py --data-type random --seed 2021 --model-type xformercode --mode en2z
   ``` 

4. To train zeroshot classification models (either baselines or ours). 

   To run EEGNet (baseline):
   ```python
   python train_zeroshot_classif.py --model-type eeg --seed 2021
   ```

   To run ours:
   ```python
   python train_zeroshot_classif.py --model-type xformer --seed 2021
   ```


### Libraries

* `lib/models/vqvae.py` holds the VQVAE model
* `lib/models/codepred.py` holds the code prediction models (transformer encoder, transformer enc-dec)
* `lib/models/decode.py` holds the code2time models