#!/bin/bash
GPU_IDS=${1:-0}
export WANDB_MODE="offline"
export NCCL_P2P_DISABLE=1
export TORCH_NCCL_ENABLE_MONITORING=0
export FINETRAINERS_LOG_LEVEL=DEBUG

DATA_ROOT="/home/nas_main/kinamkim/dataset/360/dataset_FIFO"
CAPTION_COLUMN="prompt.txt"
VIDEO_COLUMN="videos.txt"
OUTPUT_DIR="./output/360-cogvideo-front-4-noise-none-buffer"
VALID_DIR="/home/nas_main/kinamkim/dataset/360/dataset_FIFO/validate_dataset"
ID_TOKEN="360"

# Model arguments
model_cmd="--model_name cogvideox \
  --pretrained_model_name_or_path /home/nas_main/kinamkim/checkpoint/CogVideoX-5b"

# Dataset arguments
dataset_cmd="--data_root $DATA_ROOT \
  --video_column $VIDEO_COLUMN \
  --caption_column $CAPTION_COLUMN \
  --id_token $ID_TOKEN \
  --video_resolution_buckets 49x480x480 \
  --caption_dropout_p 0.05"

# Dataloader arguments
dataloader_cmd="--dataloader_num_workers 4"

# Training arguments
training_cmd="--training_type lora \
  --seed 42 \
  --batch_size 1 \
  --precompute_conditions \
  --train_steps 6000 \
  --rank 128 \
  --lora_alpha 128 \
  --target_modules to_q to_k to_v to_out.0 \
  --gradient_accumulation_steps 1 \
  --gradient_checkpointing \
  --checkpointing_steps 1000 \
  --checkpointing_limit 6 \
  --resume_from_checkpoint=latest \
  --enable_slicing \
  --enable_tiling \
  --apply_target_noise_only front-4-noise-none-buffer \
  --validation_dataset $VALID_DIR \
  --validation_steps 1000 \
  --validation_count 2 \
  --validation_fps 10"

# Optimizer arguments
optimizer_cmd="--optimizer adamw \
  --use_8bit_bnb \
  --lr 3e-5 \
  --lr_scheduler constant_with_warmup \
  --lr_warmup_steps 100 \
  --lr_num_cycles 1 \
  --beta1 0.9 \
  --beta2 0.95 \
  --weight_decay 1e-4 \
  --epsilon 1e-8 \
  --max_grad_norm 1.0"

# Miscellaneous arguments
miscellaneous_cmd="--tracker_name crepa-cog-default \
  --output_dir $OUTPUT_DIR \
  --nccl_timeout 1800 \
  --report_to wandb"

# CREPA arguments
crepa_cmd="--return_hidden_states 8"

cmd="accelerate launch --config_file accelerate_configs/uncompiled_1.yaml --gpu_ids $GPU_IDS train.py \
  $model_cmd \
  $dataset_cmd \
  $dataloader_cmd \
  $training_cmd \
  $optimizer_cmd \
  $miscellaneous_cmd \
  $crepa_cmd"

echo "Running command: $cmd"
eval $cmd
echo -ne "-------------------- Finished executing script --------------------\n\n"