# The Neural Multiplexer

This project provides code for the architectures Multiplexer, FNNR, and MFNNR-Stack.

The script "scripts/test.py" trains a model on the algorithm-simulation task from Section 4.3 of the paper. As in the paper, it trains on runs that use two iterations and evaluates on several iterations. The architectures used here only serve for demonstration purposes.

To try different variations, modify the parameters at the top of the test.py script. For more complex changes, look at the get_module() function to see how the different architectures are implemented and to change their parameters.

Note that we refer to the application of softmax and Gumbel-Softmax as a form of "attention" in this code, which may be confusing for some readers depending on their background. We are not referring to self-attention, which is a different concept.

For the reader's convenience, the models in architectures.py contain assert statements that indicate what the shape of the tensors will be at different parts of the model, which is useful for understanding the code.

A note about the regularization loss: We use a list to accumulate these losses. Each module adds a loss to the list wherever it is needed. These losses are then added up and backpropagated together with the primary loss at the end of the run.

## Requirements

To install requirements:

```setup
pip install -r requirements.txt
```

## Training and Evaluation

To train the model, run this command:

```train
python scripts/test.py
```

The current performance of the model will be printed regularly. At the end of the run, the final performance will be printed.
