# Prompt Tuning for Graph Neural Networks

This is a Pytorch implementation of our paper: **Prompt Tuning for Graph Neural Networks**. 

Our code is modified on the implementation of [1].

## Installation
We used the following Python packages for core development. We tested on `Python 3.7`.
```
pytorch                   1.4.0
torch-cluster             1.5.2              
torch-geometric           1.0.3
torch-scatter             2.0.3 
torch-sparse              0.5.1
torch-spline-conv         1.2.0
rdkit                     2022.3.4
tqdm                      4.31.1
tensorboardx              1.6
```

## Dataset download
For the chemistry dataset, download from [chem data](http://snap.stanford.edu/gnn-pretrain/data/chem_dataset.zip) (2.5GB), unzip it, and put it under `chem/`.

For the biology dataset, download from [bio data](http://snap.stanford.edu/gnn-pretrain/data/bio_dataset.zip) (2GB), unzip it, and put it under `bio/`.

## Prompt tuning
```
python finetune.py --model_file INPUT_MODEL_PATH --dataset DOWNSTREAM_DATASET
```
This will finetune the pre-trained model specified in `INPUT_MODEL_PATH` using dataset `DOWNSTREAM_DATASET` by graph prompts .

## Reference

[1] Weihua Hu, Bowen Liu, Joseph Gomes, Marinka Zitnik, Percy Liang, Vijay S. Pande, and Jure Leskovec. Strategies for pre-training graph neural networks. ICLR, 2020
