# Cooperative-Competitive Splitting for Hierarchical Mixture-of-Experts

This repository contains the implementation and experiments from our NeurIPS 2025 submission on scalable training of hierarchical mixture-of-experts (MoE) models via a probabilistic expectation-maximization scheme with cooperative and competitive splitting.

Our method:

* Blends cooperative and competitive expert training via a novel probabilistic gating formulation.
* Introduces an M-splitting EM algorithm that decouples local expert updates into embarrassingly parallel subproblems, accelerated via GPU.
* Implements a hierarchical, multilevel architecture inspired by multigrid methods, improving localization and convergence.
* Demonstrates strong GPU scalability, empirical robustness in high dimensions, and a provable convergence criterion for the iterative solver under mild assumptions.

---

## Installation

```bash
python -m venv pou_env
source pou_env/bin/activate
pip install .  
```

---

## Repository Structure

```
hierarchical_pous/
├── hierarchical_pous/      # Core module (gating, EM, splitting solvers)
├── data/
│   ├── serial_sample/      # 1D Gaussian regression    (Fig 2)
│   ├── strong_scaling/     # GPU parallelism benchmark (Fig 3)
│   ├── r_sigma_bound/      # Convergence bound study   (Fig 4)
│   ├── dim_scaling/        # Problem dimension scaling (Fig 5)
│   └── pinn/               # Performance on a PINN     (Fig 6) 
└── README.md
```

---

## Notes on PINN experiments

The cooperative scheme presented in Fig. 6 had the splitting scheme turned off due to challenges in hyperparameter tuning for the additional boundary condition terms. We present here the heavier-weighted competitive scheme with boundary condition terms removed, which allows the slitting scheme to work. However, its performance is inferior to the cooperative scheme and only comparable to vanilla PINNs, suggesting that the cooperative term plays a more crucial role in this convection-dominated setting. 

![Ablation over Peclet number](data/pinn/ablation_Pe.png)

---

## Citation

Coming soon (upon acceptance). For now, cite the repository link above.

