import pickle
from copy import deepcopy

def save_snapshots_to_file(snapshots, n_iters, filepath):
    """
    Save a list of snapshots to disk as a dict with keys 'n_iter'.

    Args:
        snapshots (list): List of snapshot dicts.
        n_iters (list): List of iteration counts corresponding to each snapshot.
        filepath (str): File path to save the pickle file.
    """
    data = {n: s for n, s in zip(n_iters, snapshots)}
    with open(filepath, 'wb') as f:
        pickle.dump(data, f)

def load_snapshots_from_file(filepath):
    """
    Load the snapshot dict from disk.

    Returns:
        dict: Dictionary of snapshots keyed by n_iter.
    """
    with open(filepath, 'rb') as f:
        return pickle.load(f)

