from enum import Enum
from typing import Optional
from dataclasses import dataclass


class SafetyLabel(Enum):
    SAFE = 0
    HARMFUL = 1


@dataclass
class SafeguardSample:
    prompt: str
    prompt_gold_label: Optional[SafetyLabel] = None
    prompt_harmful_score: Optional[float] = None
    response: Optional[str] = None
    response_gold_label: Optional[SafetyLabel] = None
    response_harmful_score: Optional[float] = None