"""
Keep biological constants here.
"""

import pandas as pd


HLA_SEQUENCE_MAP = pd.read_csv("../refs/2field_hla_consensus_seqs.csv", index_col=0).to_dict()["Full Sequence"]
HLA_PSEUDO_MAP = pd.read_csv("../refs/hla_pseudo_seqs.csv", index_col=0).to_dict()["pseudo-sequence"]
AA_VOCABULARY = ["A", "C", "D", "E", "F", "G", "H", "I", "K", "L", "M", "N", "P", "Q", "R", "S", "T", "V", "W", "Y"]

ATCHLEY_TABLE = pd.read_csv("../refs/atchley_factors.csv", index_col=0)
KIDERA_TABLE = pd.read_csv("../refs/kidera_factors.csv", index_col=0)
PROPERTIES_TABLE = pd.read_csv("../refs/aa_properties15.csv", index_col=0)


PEPTIDE_MAX_LEN = 15
MHC_MAX_LEN = 365
PSEUDO_MAX_LEN = 34
TCR_MAX_LEN = 325
CDR3_MAX_LEN = 24