# NOTE: this file must not import anything from lib.

from pathlib import Path

_PROJECT_DIR = Path.cwd()

assert _PROJECT_DIR.joinpath(
    'ROOT_FILE'
).exists(), 'The script must be run from the root of the repository'


def get_project_dir() -> Path:
    return _PROJECT_DIR


# _PROJECT_DIR: None | Path = None

# def get_project_dir() -> Path:
#     global _PROJECT_DIR
#     if _PROJECT_DIR is None:
#         cwd = Path.cwd()
#         assert cwd.joinpath(
#             '.git'
#         ).exists(), 'The script must be run from the root of the repository'
#         _PROJECT_DIR = cwd
#     return _PROJECT_DIR


def get_cache_dir() -> Path:
    path = get_project_dir() / 'cache'
    path.mkdir(exist_ok=True)
    return path


def get_data_dir() -> Path:
    return get_project_dir() / 'data'


def get_exp_dir() -> Path:
    return get_project_dir() / 'exp'
