from fschat.conversation_game import Conversation

from games.base_game import BaseGame

import re
import json
import random
import streamlit as st

akinator_prompt_file = "./data/akinator_optimized_prompts.json"

@st.cache_data
def akinator_load_prompts():
    with open(akinator_prompt_file, 'r') as f:
        system_prompts = json.load(f)
    return system_prompts

@st.cache_data
def check_akinator_valid_guess(s):
    pattern = r"this is a guess"
    if len(re.findall(pattern, s.lower())) !=0:
        return True
    else:
        return False

class Akinator(BaseGame):
    def __init__(self, max_round: int, save_path: str) -> None:
        super().__init__(max_round, save_path)
        # Meta data
        self.game_name = "Akinator"
        self.game_rule = """- Think about an object. The AI assistant will try to guess what it is.
- AI assistant will have up to 20 chances to ask questions. 
- If the AI assistant is able to successfully guess the object, They win.
"""
# (1) You should ask the first question. The question should be indexed by where N is a numerical integer from 1 to 20. Don't generate other content.
# (2) Every time you ask the YES or NO question, use the following format: 'Question N: ...', where N is a numerical integer.
        
        system_prompts = akinator_load_prompts()
        all_prompts = list(system_prompts.values())
        self.system_prompt_index = random.choice(range(len(all_prompts)))
        self.system_prompt = all_prompts[self.system_prompt_index]
        #print('system prompt idx:')
        #print(self.system_prompt_index)
        #print('system prompt:')
        #print(self.system_prompt)
        
#        self.system_prompt = """You are an intelligent assistant tasked with playing a game of Twenty Questions. Your goal is to guess a generic object that the user is thinking of. The rules are as follows:

#1. Questioning Numbering: Each question starts with a question header 'Question N:' where N is a numerical integer from 1 to 20. Ensure each question is sequentially numbered, avoiding any repetition of the question header 'Question N:'.

#2. Single Question Format: In each turn, ask only one YES or NO question. Your response should only contain the question—no extra or redundant text should be included.

#3. Accepted Answers: Only these responses are acceptable: Yes, No, Probably Yes, Probably No, Don't Know.

#4. Fault Tolerance: Be tolerant of potentially incorrect answers from the user and adjust your questions accordingly.

#5. Avoid Redundancy: Do not repeat or ask similar questions more than once. Aim to ask unique questions that progressively narrow down the possibilities.

#6. Efficient Questioning: Strategically balance asking more general questions that can broadly narrow down possibilities versus making a guess to save question quota.

#7. Confident Guessing: If confident, make a guess using the format: 'This is a guess —— are you thinking of $object?', where $object is your proposed guess. Avoid any additional text.

#8. Generic Guessing: Don’t guess too specific an object. When confident enough, make a guess with the following format: 'This is a guess —— are you thinking of $object?' 

#9. Adaptive Questioning: Base each question on the user's previous responses to refine your understanding and approach.

#10. Consider Edge Cases: When making a guess, don't constrain your thinking to a specific category. Be creative and consider edge cases to avoid premature conclusions.

#Game session begins now. Let's proceed step by step:
#        """

        self.first_user_message = (
            "I have a secret object in my mind. Now you can start asking me questions and guess it."
        )

    def is_llm_giving_answer(self, conversation: Conversation) -> bool:
        model_last_response = conversation.messages[-1][1]

        if check_akinator_valid_guess(model_last_response):
            return True
        return False

    def is_llm_triggering_termination(self, conversation: Conversation) -> bool:
        return False
    
    def is_llm_illegal_input(self, input_text: str) -> bool:
        return False