from fschat.conversation_game import Conversation

from games.base_game import BaseGame

import re
import json
import random
import streamlit as st

bluffing_prompt_file = "./data/bluffing_optimized_prompts.json"

@st.cache_data
def bluffing_load_prompts():
    with open(bluffing_prompt_file, 'r') as f:
        system_prompts = json.load(f)
    return system_prompts

def check_bluffing_valid_guess(s):
    pattern = r"i believe your statement is:"
    if len(re.findall(pattern, s.lower())) !=0:
        return True
    else:
        return False

class Bluffing(BaseGame):
    def __init__(self, max_round: int, save_path: str) -> None:
        super().__init__(max_round, save_path)

        # Meta data
        self.game_name = "Bluffing"
        self.game_rule = """- The system will provide with you a question. You can make a either true or false statement.
- In the first turn you would need to make a statement.
- Your goal is to convince the AI assistant that you are making a true statement.
- The AI assistant will ask you up to 5 questions and try to guess if you are honest based on your feedbacks.
- If the AI assistant guess correctly whether you are bluffing, They win.
"""
# (2) Every time you ask a question, use the following format: 'Question N: ...', where N is a numerical integer from 1 to 5.
# (13) After a game session has ended and you have made a guess, then encourages the user to restart with: "If you want to start a new game, please hit 'New Round'"
        
        system_prompts = bluffing_load_prompts()
        all_prompts = list(system_prompts.values())
        self.system_prompt_index = random.choice(range(len(all_prompts)))
        self.system_prompt = all_prompts[self.system_prompt_index]
        #print('system prompt idx:')
        #print(self.system_prompt_index)
        #print('system prompt:')
        #print(self.system_prompt)
        
#       self.system_prompt = """You are an intelligent assistant tasked with playing a lie detection game. At the beginning of the game, the user will make a statement about themselves. Your goal is to determine whether the statement is true based on common sense and the user's answers. Keep in mind that the user may lie in their responses. The rules are as follows:

#1. Statement Introduction: After the user makes a statement, you should proceed to ask the first question.

#2. Questioning Numbering: Each question starts with a question header 'Question N:' where N is a numerical integer from 1 to 5. Ensure each question is sequentially numbered, avoiding any repetition of the question header 'Question N:'. Don't generate the question header after the 5th question.

#3. Sequential Questioning: Ensure that each question is unique and each question header is incrementally numbered from 1 to 5. Avoid repetitively generating 'Question 1:' without incrementing the number correctly.

#4. Single Question Per Turn: Ask only one question per turn and avoid generating any additional content or redundant information.

#5. Test Expertise: Ask questions that evaluate the user's expertise and knowledge in areas related to the statement.

#6. Build on Responses: Base each subsequent question on the user’s previous responses to ensure relevance and depth.

#7. Limit of 5 Questions: You have up to 5 opportunities to ask questions.

#8. Avoid Premature Judgment: Avoid making a lie-detection judgment before all 5 questions are asked. You can reserve your judgment until the end of the questioning.

#9. Fault Tolerance: Be aware that users might provide incorrect answers by accident. Remain fault-tolerant and adjust your questioning accordingly. However, you do need to ask the user to provide sufficient details about the statement or related background.

#10. Encourage Creativity: Don’t limit yourself to a specific set of questions. Be creative and think outside the box to fully explore the truthfulness of the statement.

#11. Final Judgment: Only if you are sufficiently confident, after or before all 5 questions are asked, make your final guess using the format: 'I believe your statement is: ', followed by either 'True' or 'False'. Don't include the question header.

#12. Post-Game Analysis: Provide an analysis of the statement and your reasoning after the game session has ended.

#The game session begins now. Let’s proceed step by step:
#""" 
        self.secret_system_message = (
            None  # front-end need to ask user to provide a statement
        )

        self.first_user_message = (
            None  # front-end need to ask user to provide a statement
        )

    def is_llm_giving_answer(self, conversation: Conversation) -> bool:
        model_last_response = conversation.messages[-1][1]

        if check_bluffing_valid_guess(model_last_response):
            return True
        return False
    
    def is_llm_triggering_termination(self, conversation: Conversation) -> bool:
        return False
    
    def is_llm_illegal_input(self, input_text: str) -> bool:
        return False
