from fschat.conversation_game import Conversation

from games.base_game import BaseGame

import json
import re
from typing import List, Any, Dict, Union, Tuple
import json
import random
import streamlit as st

taboo_file = "./data/taboo.json"
taboo_prompt_file = "./data/taboo_optimized_prompts.json"
        
with open(taboo_file, 'r') as f:
    TABOO_GAME_WORD_CHOICES = []
    taboo_words = json.load(f)
    for categories in taboo_words:
        TABOO_GAME_WORD_CHOICES += taboo_words[categories]

@st.cache_data
def taboo_load_prompts():
    with open(taboo_prompt_file, 'r') as f:
        system_prompts = json.load(f)
    return system_prompts

def check_taboo_valid_guess(s):
    pattern = r"my guess of the word is:"
    if len(re.findall(pattern, s.lower())) != 0:
        return True
    else:
        return False

def check_taboo_bad_question(s, secret_phrase):
    secret_elements = secret_phrase.split(' ')
    flag = False
    for secret in secret_elements:
        if secret.lower() in s.lower():
            print('bad question!!')
            flag = True
    return flag

def check_taboo_word_uttered(s, secret):
    if secret.lower() in s.lower():
        print('secret word uttered!!')
        return True
    else:
        return False

class Taboo(BaseGame):
    def __init__(self, max_round: int, save_path: str) -> None:
        super().__init__(max_round, save_path)

        # Meta data
        self.game_name = "Taboo"
        self.game_rule = """- The system will provide with you a target word.
- The goal for you is to prompt the AI assistant with questions such that it utters the target word unconciously to win the game.
- You could not explicitly include the target word in your input. Otherwise, you lose.
- After 5 turns, if the AI assistant hasn't uttered the word. They win.
- If the AI assistant uttered the word, but is able to guess the target word correctly. They win.
"""
# (6) Your repsonse to the user's questions should start with: 'Response to your question: ...'. Otherwise, if the user is not asking a question, ask user to reask a new question.
# (10) if the user inputs START. Then answer in the following format: "If you want to start a new game, please hit 'New Round'"

# old system prompt:
#"""You are an intelligent ASSISTANT tasked with playing a game. At the beginning, the user will get a target word. 
#Your goal is to guess the target word obtained by users. Otherwise, if the user induce you to utter the target word unconciously, you will lose. Note that user's messages are forbidden to contain the word. 
#You need to follow the rules below:
#(1) Each turn the user is expected to ask a question. You should answer accordingly while avoding speaking the word or using interrogative sentences.
#(2) If the user is not asking a question, ask user to reask a new question.
#(3) Avoid generating the word that may lead to losing the game.
#(4) Based on the questions asked by the user, you should try to guess the word.
#(5) You could not directly ask any details about the target word.
#(6) Your conversation with the user should be natural and coherent.
#(7) Avoid making a guess before 5 questions are asked. Take a guess only if you are very confident.
#(8) After 5 questions have been asked, first answer the latest question and then follow the following format to make a guess of the word: 'My guess of the word is: ...'
#(9) After a game session has ended, you should make a guess of the secret word in the following format: 'my guess of the word is: ...'.
#(10) Provide an analysis on your guess after the game session has ended.
#Now the game session starts, Game session:
#"""

        system_prompts = taboo_load_prompts()
        all_prompts = list(system_prompts.values())
        self.system_prompt_index = random.choice(range(len(all_prompts)))
        self.system_prompt = all_prompts[self.system_prompt_index]
        #print('system prompt idx:')
        #print(self.system_prompt_index)
        #print('system prompt:')
        #print(self.system_prompt)
        
#       self.system_prompt = """You are an intelligent assistant tasked with playing a word-guessing game. The user will start with a target word in mind, and your goal is to guess this word. However, if the user induces you to unconsciously say the target word, you will lose. Note that the user’s messages cannot contain the word itself. Follow these rules:

#1. Respond to Questions: Each turn, the user is expected to ask a question. Answer accordingly while avoiding using the target word or forming interrogative sentences.

#2. Avoid Losing Words: Be cautious not to generate the target word or any word that might lead to losing the game.

#3. Make Educated Guesses: Based on the user’s questions, try to guess the target word, ensuring you avoid asking directly about it.

#4. Guess Upon Lossing: Only take a guess if you are very confident or you have uttered the word. Use the following format: 'My guess of the word is: ...'.

#5. Maintain Natural Dialogue: Keep the conversation with the user natural and coherent, without unnecessary content.

#6. Optional End of Game Guess: After 5 questions have been asked and only if you are sufficiently confident, first answer the latest question and then you must make a final guess of the secret word in this format: 'My guess of the word is: ...'.

#7. Post-Game Analysis: Provide an analysis along with your game guess.

#8. The game session starts now. Let’s proceed:
#"""
        
        self.secret_system_message = (
            None  # game will randomly choose a secret word for users to guess from
        )
        self.game_secret = None

        self.first_user_message = (
            None  # front-end need to ask user to provide a question
        )

    def is_llm_giving_answer(self, conversation: Conversation) -> bool:
        model_last_response = conversation.messages[-1][1]

        if check_taboo_valid_guess(model_last_response):
            return True
        return False
    
    def is_llm_triggering_termination(self, conversation: Conversation) -> bool:
        last_message = conversation.messages[-1][1]

        if check_taboo_word_uttered(last_message, self.game_secret):
            return True
        return False
    
    def is_llm_illegal_input(self, input_text: str) -> bool:
        if check_taboo_word_uttered(input_text, self.game_secret):
            return True
        return False
