import streamlit as st
from streamlit_run import Akinator, show_statement, show_message_history
import sys
import random
import json
import string

from fastchat.model.model_adapter import get_conversation_template
from fschat.api_provider_game import get_api_provider_stream_iter

from utils import get_model_list

register_api_endpoint_file = 'config/api_endpoint.json'
st.session_state.register_api_endpoint_file = register_api_endpoint_file

st.session_state.save_path = 'output.json'
st.session_state.selected_url = 'pages/akinator.py'

#st.session_state.akinator_game = Akinator(max_round=20, save_path=st.session_state.save_path)

# Define the options with scores from 1 to 10
intelligence_options = {
    "Extremely not smart (1)": 1,
    "Somewhat not smart (3)": 3,
    "Neither smart nor not smart (5)": 5,
    "Somewhat smart (7)": 7,
    "Extremely smart (10)": 10
}

def restart_game():
    st.session_state.akinator_game = Akinator(max_round=20, save_path=st.session_state.save_path)
    game_session_id = ''.join(random.choices(string.ascii_lowercase + string.digits, k=10))
    st.session_state.akinator_game.game_session_id = game_session_id

    st.session_state.akinator_game.model_name = random.choice(st.session_state.models)
    st.session_state.akinator_conversation = get_conversation_template(
        st.session_state.akinator_game.model_name
    )
    st.session_state.akinator_conversation.set_system_message(
        st.session_state.akinator_game.system_prompt
    )

    del st.session_state.akinator_game.first_user_message
    del st.session_state.akinator_game.show_message_history
    del st.session_state.akinator_game.game_start
    del st.session_state.akinator_game.next_llm_query_type
    del st.session_state.akinator_game.generate_next_llm_query
    del st.session_state.akinator_conversation
    del st.session_state.akinator_game
    
    st.rerun()

if (
    "models" not in st.session_state
    or "all_models" not in st.session_state
    or "api_endpoint_info" not in st.session_state
):
    models, all_models, api_endpoint_info = get_model_list(
        register_api_endpoint_file, multimodal=False
    )
    st.session_state.models = models
    st.session_state.all_models = all_models
    st.session_state.api_endpoint_info = api_endpoint_info

if "akinator_game" not in st.session_state:
    st.session_state.akinator_game = Akinator(max_round=20, save_path=st.session_state.save_path)
    game_session_id = ''.join(random.choices(string.ascii_lowercase + string.digits, k=10))
    st.session_state.akinator_game.game_session_id = game_session_id

    st.session_state.akinator_game.model_name = random.choice(st.session_state.models)
    st.session_state.akinator_game.generate_next_llm_query = True

if "akinator_conversation" not in st.session_state:
    st.session_state.akinator_conversation = get_conversation_template(
        st.session_state.akinator_game.model_name
    )
    st.session_state.akinator_conversation.set_system_message(
        st.session_state.akinator_game.system_prompt
    )

#st.title(f"You are playing the :orange-background[{st.session_state.akinator_game.game_name}] Game")

# Adding the disclaimer tab
with st.sidebar.expander("Disclaimer", expanded=False):
    st.markdown("""
    **By using this service, you agree to the following terms:**

    - **Purpose:** This game service is intended for research purposes only. It provides limited safety measures and may generate content that some users may find offensive.
    
    - **Prohibited Uses:** The service must not be used for any illegal, harmful, violent, racist, or sexual purposes. Please refrain from uploading any private information.
    
    - **Data Collection and Usage:** The service collects user dialogue data, including text and images. The service reserves the right to distribute this data under a Creative Commons Attribution (CC-BY) license or a similar license.
    """)

with st.expander(f"📜 :orange-background[{st.session_state.akinator_game.game_name}] Game Rules", expanded=True):
    st.write(st.session_state.akinator_game.game_rule)
    
# End game if max round is reached or user wins
if (
    (
        st.session_state.akinator_game.reach_max_round()
        or st.session_state.akinator_game.game_status == "MODEL_WIN"
    ) 
    and st.session_state.akinator_game.generate_next_llm_query
):
    st.info("Game Over!", icon="ℹ️")

    if st.session_state.akinator_game.game_status == "MODEL_WIN":
        with st.chat_message("system", avatar="🖥️"):
                st.write(
                    "Model Wins!"
                )
        #st.info("Model Wins!", icon="ℹ️")

        # Create a question for the survey
        st.write("How intelligent do you think the AI model is? Rate and get game session ID👇")
        # Display the options using a radio button
        satisfaction_label = st.radio("Select an option (Please leave the game with your final selection):", list(intelligence_options.keys()), index=None)

        if satisfaction_label:
            # Get the corresponding score for the selected option
            satisfaction_score = intelligence_options[satisfaction_label]
            st.session_state.akinator_game.user_rating = satisfaction_score
            
            st.session_state.akinator_game.post_game_data_collection(st.session_state.akinator_conversation, st.session_state.akinator_game.game_session_id)

            st.write(f"""Your Game Session ID: **{st.session_state.akinator_game.game_session_id}**\n\nPlease save the Game Session ID and enter it in the survey form for compensation.😊""")
    else:
        with st.chat_message("system", avatar="🖥️"):
                st.write(
                    "Max round reached! You win!"
                )
        #st.info("Max round reached! You win!", icon="ℹ️")
        st.session_state.akinator_game.set_end_game_status("MAX_ROUND_REACHED")

        # Create a question for the survey
        st.write("How intelligent do you think the AI model is? Rate and get game session ID👇")
        # Display the options using a radio button
        satisfaction_label = st.radio("Select an option (Please leave the game with your final selection):", list(intelligence_options.keys()), index=None)

        if satisfaction_label:
            # Get the corresponding score for the selected option
            satisfaction_score = intelligence_options[satisfaction_label]
            st.session_state.akinator_game.user_rating = satisfaction_score
            
            st.session_state.akinator_game.post_game_data_collection(st.session_state.akinator_conversation, st.session_state.akinator_game.game_session_id)

            # user inputs — secret key
            user_note = st.text_input(
                "Enter your secret object here and get game session ID👇",
                placeholder="",
            )
            if user_note and user_note != "":
                st.session_state.akinator_game.post_game_data_collection(
                    st.session_state.akinator_conversation, st.session_state.akinator_game.game_session_id, user_note
                )
                st.write("Thanks for playing! 🥳 Click 'New Round' to restart.")

                st.write(f"""Your Game Session ID: **{st.session_state.akinator_game.game_session_id}**\n\nPlease save the Game Session ID and enter it in the survey form for compensation.😊""")

    user_note = st.text_input(
        "Additional User Feedback 👇",
        placeholder="",
    )
    if user_note and user_note != "":
        st.session_state.akinator_game.post_game_data_collection(
            st.session_state.akinator_conversation, st.session_state.akinator_game.game_session_id, user_note
        )
        st.write("Thanks for providing additional feedback! 🥳 Click 'New Round' to restart.")

    new_model_col = st.columns(1)[0]
    with new_model_col:
        if st.button("New Round", use_container_width=True):
            restart_game()

    st.subheader("Game Conversation")

    show_message_history(st.session_state.akinator_game.game_name)
    st.stop()

# Display Game Conversation
if not st.session_state.akinator_game.game_start:
    st.session_state.akinator_game.initialize_game(st.session_state.akinator_conversation)
    st.session_state.akinator_game.show_message_history = False
    st.session_state.akinator_game.game_start = True
    st.session_state.akinator_game.next_llm_query_type = "question"
    # generate_response()
    st.rerun()
else:
    with st.container(border=True):
        # llm_last_response = st.session_state.akinator_conversation.messages[-1]
        if st.session_state.akinator_game.generate_next_llm_query:
            #try:
                with st.chat_message("assistant"):
                    def stream_and_update():
                        for chunk in st.session_state.akinator_game.generation_response(
                            st.session_state.akinator_game.next_llm_query_type,
                            get_api_provider_stream_iter,
                            st.session_state.akinator_conversation,
                            st.session_state.akinator_game.model_name,
                            st.session_state.api_endpoint_info[st.session_state.akinator_game.model_name],
                        ):
                            yield chunk
                    st.write_stream(stream_and_update)
                    st.session_state.akinator_game.generate_next_llm_query = False
            #except Exception as e:
            #    st.error(f"An error occurred: {e}. Restarting the game...")
            #    restart_game()
        else:
            # show previous question
            conv_length = len(st.session_state.akinator_conversation.messages)
            show_message_history(st.session_state.akinator_game.game_name, starting_turn=conv_length-1)

    if st.session_state.akinator_game.is_llm_giving_answer(st.session_state.akinator_conversation):
        model_win_col, model_lose_col = st.columns(2)
        with model_win_col:
            if st.button("Model is Correct", use_container_width=True):
                st.session_state.akinator_game.update_conversation_with_user_choice(
                    st.session_state.akinator_conversation, "MODEL_WIN"
                )
                st.session_state.akinator_game.set_end_game_status("MODEL_WIN")

                st.session_state.akinator_game.next_llm_query_type = "question"
                st.session_state.akinator_game.generate_next_llm_query = True
                st.rerun()
        with model_lose_col:
            if st.button("Model is Wrong", use_container_width=True):
                st.session_state.akinator_game.update_conversation_with_user_choice(
                    st.session_state.akinator_conversation, "No"
                )
                st.session_state.akinator_game.next_llm_query_type = "question"
                st.session_state.akinator_game.generate_next_llm_query = True
                st.rerun()
    elif st.session_state.akinator_game.is_llm_triggering_termination(st.session_state.akinator_conversation):
        raise NotImplementedError(f"LLM-triggered termination conditions for game: {st.session_state.akinator_game.game_name} is not implemented.")
    else:
        col1, col2, col3, col4, col5 = st.columns(5)
        # Answer buttons
        with col1:
            if st.button("Yes", use_container_width=True):
                st.session_state.akinator_game.update_conversation_with_user_choice(
                    st.session_state.akinator_conversation, "Yes"
                )
                st.session_state.akinator_game.next_llm_query_type = "question"
                st.session_state.akinator_game.generate_next_llm_query = True
                # generate_response()
                st.rerun()
        with col2:
            if st.button("Probably Yes", use_container_width=True):
                st.session_state.akinator_game.update_conversation_with_user_choice(
                    st.session_state.akinator_conversation, "Probably Yes"
                )
                st.session_state.akinator_game.next_llm_query_type = "question"
                st.session_state.akinator_game.generate_next_llm_query = True
                # generate_response()
                st.rerun()
        with col3:
            if st.button("Don't Know", use_container_width=True):
                st.session_state.akinator_game.update_conversation_with_user_choice(
                    st.session_state.akinator_conversation, "Don't Know"
                )
                st.session_state.akinator_game.next_llm_query_type = "question"
                st.session_state.akinator_game.generate_next_llm_query = True
                # generate_response()
                st.rerun()
        with col4:
            if st.button("Probably No", use_container_width=True):
                st.session_state.akinator_game.update_conversation_with_user_choice(
                    st.session_state.akinator_conversation, "Probably No"
                )
                st.session_state.akinator_game.next_llm_query_type = "question"
                st.session_state.akinator_game.generate_next_llm_query = True
                # generate_response()
                st.rerun()
        with col5:
            if st.button("No", use_container_width=True):
                st.session_state.akinator_game.update_conversation_with_user_choice(
                    st.session_state.akinator_conversation, "No"
                )
                st.session_state.akinator_game.next_llm_query_type = "question"
                st.session_state.akinator_game.generate_next_llm_query = True
                # generate_response()
                st.rerun()
        
        undo_col = st.columns(1)[0]
        # Answer buttons
        with undo_col:
            if st.button("Undo", use_container_width=True):
                if len(st.session_state.akinator_conversation.messages) > 2:
                    del st.session_state.akinator_conversation.messages[-2:]
                    assert st.session_state.akinator_game.round > 1
                    st.session_state.akinator_game.round -= 1
                    st.rerun()
                elif len(st.session_state.akinator_conversation.messages) > 0:
                    st.write("Can not undo as you have reached the first question.")