import streamlit as st
from streamlit_run import Taboo, TABOO_GAME_WORD_CHOICES, show_statement, show_message_history, get_input_instruction
import sys
import random
import json
import string

from fastchat.model.model_adapter import get_conversation_template
from fschat.api_provider_game import get_api_provider_stream_iter

from utils import get_model_list

register_api_endpoint_file = 'config/api_endpoint.json'
st.session_state.register_api_endpoint_file = register_api_endpoint_file

st.session_state.save_path = 'output.json'
st.session_state.selected_url = 'pages/taboo.py'

#st.session_state.taboo_game = Taboo(max_round=5, save_path=st.session_state.save_path)

# Define the options with scores from 1 to 10
intelligence_options = {
    "Extremely not smart (1)": 1,
    "Somewhat not smart (3)": 3,
    "Neither smart nor not smart (5)": 5,
    "Somewhat smart (7)": 7,
    "Extremely smart (10)": 10
}

def restart_game():
    st.session_state.taboo_game = Taboo(max_round=5, save_path=st.session_state.save_path)
    game_session_id = ''.join(random.choices(string.ascii_lowercase + string.digits, k=10))
    st.session_state.taboo_game.game_session_id = game_session_id

    st.session_state.taboo_game.model_name = random.choice(st.session_state.models)
    st.session_state.taboo_conversation = get_conversation_template(
        st.session_state.taboo_game.model_name
    )
    st.session_state.taboo_conversation.set_system_message(
        st.session_state.taboo_game.system_prompt
    )

    del st.session_state.taboo_game.first_user_message
    del st.session_state.taboo_game.show_message_history
    del st.session_state.taboo_game.game_start
    del st.session_state.taboo_game.next_llm_query_type
    del st.session_state.taboo_game.generate_next_llm_query
    del st.session_state.taboo_conversation
    del st.session_state.taboo_game
    
    st.rerun()

if (
    "models" not in st.session_state
    or "all_models" not in st.session_state
    or "api_endpoint_info" not in st.session_state
):
    models, all_models, api_endpoint_info = get_model_list(
        register_api_endpoint_file, multimodal=False
    )
    st.session_state.models = models
    st.session_state.all_models = all_models
    st.session_state.api_endpoint_info = api_endpoint_info

if "taboo_game" not in st.session_state:
    st.session_state.taboo_game = Taboo(max_round=5, save_path=st.session_state.save_path)
    game_session_id = ''.join(random.choices(string.ascii_lowercase + string.digits, k=10))
    st.session_state.taboo_game.game_session_id = game_session_id

    st.session_state.taboo_game.model_name = random.choice(st.session_state.models)
    st.session_state.taboo_game.generate_next_llm_query = True

if "taboo_conversation" not in st.session_state:
    st.session_state.taboo_conversation = get_conversation_template(
        st.session_state.taboo_game.model_name
    )
    st.session_state.taboo_conversation.set_system_message(
        st.session_state.taboo_game.system_prompt
    )

#st.title(f"You are playing the :orange-background[{st.session_state.taboo_game.game_name}] Game")

# Adding the disclaimer tab
with st.sidebar.expander("Disclaimer", expanded=False):
    st.markdown("""
    **By using this service, you agree to the following terms:**

    - **Purpose:** This game service is intended for research purposes only. It provides limited safety measures and may generate content that some users may find offensive.
    
    - **Prohibited Uses:** The service must not be used for any illegal, harmful, violent, racist, or sexual purposes. Please refrain from uploading any private information.
    
    - **Data Collection and Usage:** The service collects user dialogue data, including text and images. The service reserves the right to distribute this data under a Creative Commons Attribution (CC-BY) license or a similar license.
    """)

with st.expander(f"📜 :orange-background[{st.session_state.taboo_game.game_name}] Game Rules", expanded=True):
    st.write(st.session_state.taboo_game.game_rule)
    
# End game if max round is reached or user wins
# 1) ends with a user feedback button
# 2) ends with a LLM generation after the max round is reached
# 3) permits an extra taboo guess if key word is uttered in the last turn
if (
        (
            (
                st.session_state.taboo_game.game_status == "MODEL_WIN"
                or st.session_state.taboo_game.game_status == "MODEL_LOSE"
            )
            or 
            (
                st.session_state.taboo_game.reach_max_round()
                and not st.session_state.taboo_game.is_llm_giving_answer(st.session_state.taboo_conversation)
            )
        )
        and not st.session_state.taboo_game.next_llm_query_type == "taboo_guess"
):
    st.info("Game Over!", icon="ℹ️")

    if st.session_state.taboo_game.game_status == "MODEL_WIN":
        with st.chat_message("system", avatar="🖥️"):
                st.write(
                    "The Model Wins!"
                )
        #st.info("Model Wins!", icon="ℹ️")
        st.session_state.taboo_game.post_game_data_collection(st.session_state.taboo_conversation, st.session_state.taboo_game.game_session_id)

        # Create a question for the survey
        st.write("How intelligent do you think the AI model is? Rate and get game session ID👇")
        # Display the options using a radio button
        satisfaction_label = st.radio("Select an option (Please leave the game with your final selection):", list(intelligence_options.keys()), index=None)

        if satisfaction_label:
            # Get the corresponding score for the selected option
            satisfaction_score = intelligence_options[satisfaction_label]
            st.session_state.taboo_game.user_rating = satisfaction_score

            st.session_state.taboo_game.post_game_data_collection(st.session_state.taboo_conversation, st.session_state.taboo_game.game_session_id)

            st.write(f"""Your Game Session ID: **{st.session_state.taboo_game.game_session_id}**\n\nPlease save the Game Session ID and enter it in the survey form for compensation.😊""")

    elif st.session_state.taboo_game.game_status == "MODEL_LOSE":
        with st.chat_message("system", avatar="🖥️"):
                st.write(
                    "You Win!"
                )
        #st.info("You Win!", icon="ℹ️")
        st.session_state.taboo_game.post_game_data_collection(st.session_state.taboo_conversation, st.session_state.taboo_game.game_session_id)

        # Create a question for the survey
        st.write("How intelligent do you think the AI model is? Rate and get game session ID👇")
        # Display the options using a radio button
        satisfaction_label = st.radio("Select an option (Please leave the game with your final selection):", list(intelligence_options.keys()), index=None)

        if satisfaction_label:
            # Get the corresponding score for the selected option
            satisfaction_score = intelligence_options[satisfaction_label]
            st.session_state.taboo_game.user_rating = satisfaction_score
            
            st.session_state.taboo_game.post_game_data_collection(st.session_state.taboo_conversation, st.session_state.taboo_game.game_session_id)

            st.write(f"""Your Game Session ID: **{st.session_state.taboo_game.game_session_id}**\n\nPlease save the Game Session ID and enter it in the survey form for compensation.😊""")


    else:
        with st.chat_message("system", avatar="🖥️"):
                st.write(
                    "Max round reached but you failed to make LLM utter the word! The Model Wins!"
                )
        #st.info("Max round reached! You win!", icon="ℹ️")
        st.session_state.taboo_game.set_end_game_status("MAX_ROUND_REACHED")
        st.session_state.taboo_game.post_game_data_collection(st.session_state.taboo_conversation, st.session_state.taboo_game.game_session_id)

        # Create a question for the survey
        st.write("How intelligent do you think the AI model is? Rate and get game session ID👇")
        # Display the options using a radio button
        satisfaction_label = st.radio("Select an option (Please leave the game with your final selection):", list(intelligence_options.keys()), index=None)

        if satisfaction_label:
            # Get the corresponding score for the selected option
            satisfaction_score = intelligence_options[satisfaction_label]
            st.session_state.taboo_game.user_rating = satisfaction_score
            
            st.session_state.taboo_game.post_game_data_collection(st.session_state.taboo_conversation, st.session_state.taboo_game.game_session_id)

            st.write(f"""Your Game Session ID: **{st.session_state.taboo_game.game_session_id}**\n\nPlease save the Game Session ID and enter it in the survey form for compensation.😊""")

    user_note = st.text_input(
        "Additional User Feedback 👇",
        placeholder="",
    )
    if user_note and user_note != "":
        st.session_state.taboo_game.post_game_data_collection(
            st.session_state.taboo_conversation, st.session_state.taboo_game.game_session_id, user_note
        )
        st.write("Thanks for providing additional feedback! 🥳 Click 'New Round' to restart.")

    new_model_col = st.columns(1)[0]
    with new_model_col:
        if st.button("New Round", use_container_width=True):
            restart_game()
    
    st.subheader("Game Conversation")
    show_statement(st.session_state.taboo_game.game_name)
    show_message_history(st.session_state.taboo_game.game_name, starting_turn=0)
    st.stop()

# Display Game Conversation
if not st.session_state.taboo_game.game_start:
    if (
        st.session_state.taboo_game.first_user_message
        and st.session_state.taboo_game.first_user_message != ""
        and len(st.session_state.taboo_conversation.messages) <= 1
    ):
        st.session_state.taboo_game.initialize_game(st.session_state.taboo_conversation)
        st.session_state.taboo_game.show_message_history = True
        st.session_state.taboo_game.game_start = True
        st.session_state.taboo_game.next_llm_query_type = "answer"
        # generate_response(type='answer')
        
        st.rerun()
    else:
        if not st.session_state.taboo_game.secret_system_message:
            game_word = random.choice(TABOO_GAME_WORD_CHOICES)
            st.session_state.taboo_game.game_secret = game_word
            
            st.session_state.taboo_game.secret_system_message = f"""System message — Here is your target word: {game_word}."""
        
        show_statement(st.session_state.taboo_game.game_name)
        text_input = st.text_input(
            "The AI model can't see the word.\n\nPlease start asking your first question and make the model utter the target word unconciously 👇",
            placeholder="",
        )
        if text_input and text_input != "":
            # check illegal inputs
            if st.session_state.taboo_game.is_llm_illegal_input(text_input):
                text_input = text_input + """\n\n🖥️ System Message — User question contains explicit information about the secret word! The user have lost. Now you can make a guess of the word.
                """
            
            st.session_state.taboo_game.first_user_message = text_input
            
            st.rerun()
else:
    # Show statement if it is a Bluffing or Taboo game
    show_statement(st.session_state.taboo_game.game_name)
        
    with st.container(border=True):
        # llm_last_response = st.session_state.taboo_conversation.messages[-1]
        if st.session_state.taboo_game.show_message_history:
            show_message_history(st.session_state.taboo_game.game_name, starting_turn=0)
        
        if st.session_state.taboo_game.generate_next_llm_query:
            try:
                with st.chat_message("assistant"):
                    def stream_and_update():
                        for chunk in st.session_state.taboo_game.generation_response(
                            st.session_state.taboo_game.next_llm_query_type,
                            get_api_provider_stream_iter,
                            st.session_state.taboo_conversation,
                            st.session_state.taboo_game.model_name,
                            st.session_state.api_endpoint_info[st.session_state.taboo_game.model_name],
                        ):
                            yield chunk
                    st.write_stream(stream_and_update)
                    st.session_state.taboo_game.generate_next_llm_query = False
                    if st.session_state.taboo_game.next_llm_query_type == "taboo_guess":
                        # to trigger termination condition
                        st.session_state.taboo_game.next_llm_query_type = "answer"
            
            except Exception as e:
                st.error(f"An error occurred: {e}. Restarting the game...")
                restart_game()

    # check LLM generation, and ask the user to provide input
    if st.session_state.taboo_game.is_llm_giving_answer(st.session_state.taboo_conversation):

        model_win_col, model_lose_col = st.columns(2)
        with model_win_col:
            if st.button("Model is Correct", use_container_width=True):
                st.session_state.taboo_game.update_conversation_with_user_choice(
                    st.session_state.taboo_conversation, "MODEL_WIN"
                )
                st.session_state.taboo_game.set_end_game_status("MODEL_WIN")
                st.session_state.taboo_game.generate_next_llm_query = False
                if st.session_state.taboo_game.next_llm_query_type == "taboo_guess":
                    # to trigger termination condition
                    st.session_state.taboo_game.next_llm_query_type = "answer"
                st.rerun()
                
        with model_lose_col:
            if st.button("Model is Wrong", use_container_width=True):
                st.session_state.taboo_game.update_conversation_with_user_choice(
                    st.session_state.taboo_conversation, "MODEL_LOSE"
                )
                st.session_state.taboo_game.set_end_game_status("MODEL_LOSE")
                st.session_state.taboo_game.generate_next_llm_query = False
                if st.session_state.taboo_game.next_llm_query_type == "taboo_guess":
                    # to trigger termination condition
                    st.session_state.taboo_game.next_llm_query_type = "answer"
                st.rerun()
    elif st.session_state.taboo_game.is_llm_triggering_termination(st.session_state.taboo_conversation):

        # Automatic response generation — to request for a taboo guess
        # set or reset the 'taboo_guess' state
        if st.session_state.taboo_game.round < st.session_state.taboo_game.max_round + 1:
            st.session_state.taboo_game.update_conversation_with_user_choice(
                st.session_state.taboo_conversation, "The key word is uttered in your previous response. Now make a guess of the secret word."
            )
            st.session_state.taboo_game.next_llm_query_type = "taboo_guess"
            # generate_response(type='answer')
        elif st.session_state.taboo_game.next_llm_query_type == "taboo_guess":
                # if a previous taboo guess has already been made and max turn exceeded, terminate the game
                # to trigger termination condition
                st.session_state.taboo_game.next_llm_query_type = "answer"
        st.session_state.taboo_game.generate_next_llm_query = True
        st.rerun()

    elif not st.session_state.taboo_game.reach_max_round():
        game_specific_input_instruction = get_input_instruction[st.session_state.taboo_game.game_name]
        user_prompt = st.chat_input(game_specific_input_instruction, max_chars=140)
        if user_prompt:
            st.session_state.taboo_game.update_conversation_with_user_choice(
                    st.session_state.taboo_conversation, user_prompt
                )
            st.session_state.taboo_game.next_llm_query_type = "answer"
            st.session_state.taboo_game.generate_next_llm_query = True

            # check illegal inputs
            if st.session_state.taboo_game.is_llm_triggering_termination(st.session_state.taboo_conversation):
                st.session_state.taboo_conversation.messages[-1][1] = st.session_state.taboo_conversation.messages[-1][1] + """\n\n🖥️ System Message — User question contains explicit information about the secret word! The user have lost. Now you can make a guess of the word.
                """           
            st.rerun()
    else:
        # return immediately if max round exceeded and not to conduct one-time taboo guess
        st.rerun()