import json
import random

# Load the JSON data from the file
with open('/home/ubuntu/AI-ESP-serve/output_cleaned.json', 'r') as file:
    data = json.load(file)

# Ensure the JSON data is a list of entries
if isinstance(data, list):
    random_sample = random.sample(data, 30)
    
    # Save the random sample to a new JSON file
    with open('/home/ubuntu/AI-ESP-serve/output_cleaned_sampled.json', 'w') as output_file:
        json.dump(random_sample, output_file, indent=4)
    
    print("Random sample of 30 entries has been saved to '/home/ubuntu/AI-ESP-serve/output_cleaned_sampled.json'.")
else:
    print("The JSON data is not a list of entries.")