import random
import sys

import json

import streamlit as st
from fastchat.model.model_adapter import get_conversation_template
from fastchat.serve.api_provider_game import get_api_provider_stream_iter

from games import Akinator, Bluffing, Taboo, TABOO_GAME_WORD_CHOICES
from utils import get_model_list


# def generate_response(type='question'):
#     response = st.session_state.game.generation_response(
#         type,
#         get_api_provider_stream_iter,
#         st.session_state.conversation,
#         st.session_state.model_name,
#         st.session_state.api_endpoint_info[st.session_state.model_name],
#     )
#     return response

def show_statement(game):
    if game == 'Bluffing':
        if st.session_state.bluffing_game.secret_system_message:
            with st.chat_message("system", avatar="🖥️"):
                st.write(
                    f":orange-background[{st.session_state.bluffing_game.secret_system_message}]"
                )
    elif game == 'Taboo':
        if st.session_state.taboo_game.secret_system_message:
            with st.chat_message("system", avatar="🖥️"):
                st.write(
                    f":orange-background[{st.session_state.taboo_game.secret_system_message}]"
                )
    else:
        raise NotImplementedError(f"statement for game: {game} not implemented.")
            
def show_message_history(game, starting_turn=1):
    # TODO: refactor code
    if game == 'Bluffing':
        for idx, message in enumerate(st.session_state.bluffing_conversation.messages):
            if idx < starting_turn:
                continue
            if idx % 2 == 0:  # User messages are at even indices
                if message[1] != "":
                    with st.chat_message("user"):
                        st.write(message[1])
            if idx % 2 != 0:  # LLM messages are at odd indices=
                with st.chat_message("assistant"):
                    st.write(message[1])
    elif game == 'Taboo':
        for idx, message in enumerate(st.session_state.taboo_conversation.messages):
            if idx < starting_turn:
                continue
            if idx % 2 == 0:
                if message[1] != "":
                    with st.chat_message("user"):
                        st.write(message[1])
            if idx % 2 != 0:
                with st.chat_message("assistant"):
                    st.write(message[1])
    elif game == 'Akinator':
        for idx, message in enumerate(st.session_state.akinator_conversation.messages):
            if idx < starting_turn:
                continue
            if idx % 2 == 0:
                if message[1] != "":
                    with st.chat_message("user"):
                        st.write(message[1])
            if idx % 2 != 0:
                with st.chat_message("assistant"):
                    st.write(message[1])
    else:
        raise NotImplementedError(f"message history for game: {game} not implemented.")

game_cls = {
    "Akinator": Akinator,
    "Bluffing": Bluffing,
    "Taboo": Taboo,
}

get_input_instruction = {
    "Bluffing": "Please write your answer here.",
    "Taboo": "Please write your question here. You can enter a maximum of 140 characters.",
}

available_game = ["Akinator", "Bluffing", "Taboo", "Random"]

available_game_urls = ["pages/akinator.py", "pages/bluffing.py", "pages/taboo.py"]

def get_game_url(game_name, game_urls):
    for game_url in game_urls:
        if game_name.lower() in game_url:
            return game_url
    return None

def run_game(controller_url, register_api_endpoint_file, max_round=20, save_path="output.json", moderate=False):
    if (
        "models" not in st.session_state
        or "all_models" not in st.session_state
        or "api_endpoint_info" not in st.session_state
    ):
        models, all_models, api_endpoint_info = get_model_list(
            controller_url, register_api_endpoint_file, multimodal=False
        )
        st.session_state.models = models
        st.session_state.all_models = all_models
        st.session_state.api_endpoint_info = api_endpoint_info

    if "selected_game" not in st.session_state:
        st.session_state.selected_game = random.choice(available_game[:-1])

    #st.title("Chat with SOTA Large Language Models for Interactive Gameplay :star:")

    # with st.sidebar:
    #     st.subheader("Choose a game to play: (for testing purpose, when deploying, this sidebar will be removed)")
    #     selected_game = st.selectbox("Choose a game to play:", available_game, index=3)
    #     if selected_game == "Random":
    #         selected_game = random.choice(available_game[:-1])
    #     start_button = st.button("Ready")
    #     if start_button:
    #         st.session_state.selected_game = selected_game

    if "model_name" not in st.session_state:
        st.session_state.model_name = random.choice(st.session_state.models)

    if "game" not in st.session_state:
        st.session_state.game = game_cls[st.session_state.selected_game](
            max_round, save_path
        )

    if "conversation" not in st.session_state:
        st.session_state.conversation = get_conversation_template(
            st.session_state.model_name
        )
        st.session_state.conversation.set_system_message(
            st.session_state.game.system_prompt
        )

    st.title(f"You are playing the :orange-background[{st.session_state.game.game_name}] Game")

    st.subheader(st.session_state.game.game_rule)

    new_model_col = st.columns(1)[0]
    with new_model_col:
        if st.button("New Round", use_container_width=True):
            st.session_state.model_name = random.choice(st.session_state.models)
            st.session_state.game = game_cls[st.session_state.selected_game](
                max_round, save_path
            )
            st.session_state.conversation = get_conversation_template(
                st.session_state.model_name
            )
            st.session_state.conversation.set_system_message(
                st.session_state.game.system_prompt
            )

            del st.session_state.text_input
            del st.session_state.first_user_message
            del st.session_state.show_message_history
            del st.session_state.game_start
            del st.session_state.next_llm_query_type
            del st.session_state.generate_next_llm_query
            
            
            st.rerun()

    if "text_input" not in st.session_state:
        st.session_state.text_input = None
    if "first_user_message" not in st.session_state:
        st.session_state.first_user_message = None
    if "show_message_history" not in st.session_state:
        st.session_state.show_message_history = False
    if "game_start" not in st.session_state:
        st.session_state.game_start = False
    if "next_llm_query_type" not in st.session_state:
        st.session_state.next_llm_query_type = ""
    if "generate_next_llm_query" not in st.session_state:
        st.session_state.generate_next_llm_query = True
        
    # End game if max round is reached or user wins
    if (
        st.session_state.game.reach_max_round()
        or st.session_state.game.game_status == "MODEL_WIN"
        or st.session_state.game.game_status == "MODEL_LOSE"
    ):
        st.info("Game Over!", icon="ℹ️")

        if st.session_state.game.game_status == "MODEL_WIN":
            st.info("Model Wins!", icon="ℹ️")
            st.session_state.game.post_game_data_collection(st.session_state.conversation)
        elif st.session_state.game.game_status == "MODEL_LOSE":
            st.info("You Win!", icon="ℹ️")
            st.session_state.game.post_game_data_collection(st.session_state.conversation)
        else:
            st.info("Max round reached! You win!", icon="ℹ️")
            user_note = st.text_input(
                "User Feedback 👇",
                placeholder="",
            )
            if user_note and user_note != "":
                st.session_state.game.post_game_data_collection(
                    st.session_state.conversation, user_note
                )
        st.subheader("Game Conversation")
        if st.session_state.game.game_name in ["Bluffing", "Taboo"]:
            show_statement()
        if st.session_state.game.game_name in ["Taboo"]:
            show_message_history(starting_turn=0)
        else:
            show_message_history()
        st.stop()

    # Display Game Conversation
    if not st.session_state.game_start:
        if st.session_state.game.game_name in ["Bluffing"]:
            if (
                st.session_state.game.first_user_message
                and st.session_state.game.first_user_message != ""
                and len(st.session_state.conversation.messages) <= 1
            ):
                st.session_state.game.initialize_game(st.session_state.conversation)
                st.session_state.show_message_history = True
                st.session_state.game_start = True
                st.session_state.next_llm_query_type = "question"
                
                
                st.rerun()
            else:
                with st.chat_message("system", avatar="🖥️"):
                    with open('./data/bluffing.json', 'r') as f:
                        questions = json.load(f)
                    st.write(f":orange-background[{random.choice(questions)}]")
                text_input = st.text_input(
                    "Provide a statement 👇",
                    placeholder="",
                )
                if text_input and text_input != "":
                    st.session_state.game.secret_system_message = 'Statement: ' + text_input
                    st.session_state.game.first_user_message = 'Statement: ' + text_input
                    
                    st.rerun()
        elif st.session_state.game.game_name in ["Taboo"]:
            if (
                st.session_state.game.first_user_message
                and st.session_state.game.first_user_message != ""
                and len(st.session_state.conversation.messages) <= 1
            ):
                print(st.session_state.game.first_user_message)
                print(st.session_state.game.first_user_message != "")
                print(len(st.session_state.conversation.messages) <= 1)
                st.session_state.game.initialize_game(st.session_state.conversation)
                st.session_state.show_message_history = True
                st.session_state.game_start = True
                st.session_state.next_llm_query_type = "answer"
                if st.session_state.game.is_llm_triggering_termination(st.session_state.conversation):
                    st.session_state.conversation.messages[-1][1] = st.session_state.conversation.messages[-1][1] + """\n\nSystem message — User question contains explicit information about the secret word! The user have lost. Now you can make a guess of the word.
                    """

                # generate_response(type='answer')
                
                st.rerun()
            else:
                if not st.session_state.game.secret_system_message:
                    game_word = random.choice(TABOO_GAME_WORD_CHOICES)
                    st.session_state.game.game_secret = game_word
                    
                    st.session_state.game.secret_system_message = f"""System message — Here is your target word: {game_word}."""
                
                show_statement()
                text_input = st.text_input(
                    "The AI model can't see the word.\n\nPlease start asking your first question and make the model utter the target word unconciously 👇",
                    placeholder="",
                )
                if text_input and text_input != "":
                    st.session_state.game.first_user_message = text_input
                    
                    st.rerun()
        else:
            st.session_state.game.initialize_game(st.session_state.conversation)
            st.session_state.show_message_history = False
            st.session_state.game_start = True
            st.session_state.next_llm_query_type = "question"
            # generate_response()
            
            st.rerun()     
    else:
        # Show statement if it is a Bluffing or Taboo game
        if st.session_state.game.game_name in ["Bluffing", "Taboo"]:
            show_statement()
            
        with st.container(border=True):
            # llm_last_response = st.session_state.conversation.messages[-1]
            if st.session_state.show_message_history:
                if st.session_state.game.game_name in ["Taboo"]:
                    show_message_history(starting_turn=0)
                else:
                    show_message_history()
            if st.session_state.generate_next_llm_query:
                with st.chat_message("assistant"):
                    def stream_and_update():
                        for chunk in st.session_state.game.generation_response(
                            st.session_state.next_llm_query_type,
                            get_api_provider_stream_iter,
                            st.session_state.conversation,
                            st.session_state.model_name,
                            st.session_state.api_endpoint_info[st.session_state.model_name],
                        ):
                            yield chunk
                    st.write_stream(stream_and_update)
                    st.session_state.generate_next_llm_query = False
                # st.write(llm_last_response[1])

        if st.session_state.game.is_llm_giving_answer(st.session_state.conversation):
            model_win_col, model_lose_col = st.columns(2)
            with model_win_col:
                if st.button("Model is Correct", use_container_width=True):
                    st.session_state.game.update_conversation_with_user_choice(
                        st.session_state.conversation, "MODEL_WIN"
                    )
                    st.session_state.game.set_end_game_status("MODEL_WIN")
                    # st.write("Game Over! Model Wins!")
                    # st.session_state.game.post_game_data_collection(
                    #     st.session_state.conversation
                    # )
                    st.session_state.generate_next_llm_query = True
                    
                    st.rerun()
            with model_lose_col:
                if st.button("Model is Wrong", use_container_width=True):
                    st.session_state.game.update_conversation_with_user_choice(
                        st.session_state.conversation, "MODEL_LOSE"
                    )
                    st.session_state.game.set_end_game_status("MODEL_LOSE")
                    # st.write("Game Over! You Win!")
                    # user_note = st.text_area("What is the correct answer?", height=100)
                    # st.session_state.game.post_game_data_collection(
                    #     st.session_state.conversation, user_note
                    # )
                    st.session_state.generate_next_llm_query = True
                    
                    st.rerun()
        elif st.session_state.game.is_llm_triggering_termination(st.session_state.conversation):
            if st.session_state.game.game_name in ["Taboo"]:
                st.session_state.game.update_conversation_with_user_choice(
                    st.session_state.conversation, "The key word is uttered. Now make a guess of the secret word in the following format: 'my guess of the word is: ...'"
                )
                st.session_state.next_llm_query_type = "answer"
                st.session_state.generate_next_llm_query = True
                # generate_response(type='answer')
                
                st.rerun()
            else:
                raise NotImplementedError(f"game: {st.session_state.game.game_name} is not implemented.")
        else:
            if st.session_state.game.game_name in ["Bluffing", "Taboo"]:
                # TODO: add user-defined text input for user-side questions or answers
                game_specific_input_instruction = get_input_instruction[st.session_state.game.game_name]
                user_prompt = st.chat_input(game_specific_input_instruction)
                if user_prompt:
                    st.session_state.game.update_conversation_with_user_choice(
                            st.session_state.conversation, user_prompt
                        )
                    # asdf
                    if st.session_state.game.game_name in ["Bluffing"]:
                        # generate_response()
                        st.session_state.next_llm_query_type = "question"
                    else:
                        # generate_response(type='answer')
                        st.session_state.next_llm_query_type = "answer"
                    st.session_state.generate_next_llm_query = True
                    
                    st.rerun()
            elif st.session_state.game.game_name in ["Akinator"]:
                col1, col2, col3, col4, col5 = st.columns(5)
                # Answer buttons
                with col1:
                    if st.button("Yes", use_container_width=True):
                        st.session_state.game.update_conversation_with_user_choice(
                            st.session_state.conversation, "Yes"
                        )
                        st.session_state.next_llm_query_type = "question"
                        st.session_state.generate_next_llm_query = True
                        # generate_response()
                        
                        st.rerun()
                with col2:
                    if st.button("Probably Yes", use_container_width=True):
                        st.session_state.game.update_conversation_with_user_choice(
                            st.session_state.conversation, "Probably Yes"
                        )
                        st.session_state.next_llm_query_type = "question"
                        st.session_state.generate_next_llm_query = True
                        # generate_response()
                        
                        st.rerun()
                with col3:
                    if st.button("Don't Know", use_container_width=True):
                        st.session_state.game.update_conversation_with_user_choice(
                            st.session_state.conversation, "Don't Know"
                        )
                        st.session_state.next_llm_query_type = "question"
                        st.session_state.generate_next_llm_query = True
                        # generate_response()
                        
                        st.rerun()
                with col4:
                    if st.button("Probably No", use_container_width=True):
                        st.session_state.game.update_conversation_with_user_choice(
                            st.session_state.conversation, "Probably No"
                        )
                        st.session_state.next_llm_query_type = "question"
                        st.session_state.generate_next_llm_query = True
                        # generate_response()
                        
                        st.rerun()
                with col5:
                    if st.button("No", use_container_width=True):
                        st.session_state.game.update_conversation_with_user_choice(
                            st.session_state.conversation, "No"
                        )
                        st.session_state.next_llm_query_type = "question"
                        st.session_state.generate_next_llm_query = True
                        # generate_response()
                        
                        st.rerun()