import streamlit as st
import random
import sys

available_game_urls = ["pages/akinator.py", "pages/bluffing.py", "pages/taboo.py"]

st.session_state.register_api_endpoint_file = sys.argv[1]


try:
    if st.session_state.selected_url != None:
        other_games = list(filter(lambda x: x != st.session_state.selected_url, available_game_urls))
        chosen_game = random.choice(other_games)
except AttributeError:
    chosen_game = random.choice(available_game_urls)

st.session_state.selected_url = chosen_game
print(f'selected game: {st.session_state.selected_url}')
st.switch_page(chosen_game)