from src.info.base import BaseInfo

class CGE_CLSInfo(BaseInfo):
    def __init__(self, args, best, last):
        super().__init__(args)


        self.c_rot = args.c_rot
        self.g_rot = args.g_rot
        self.n_flip = args.n_flip
        self.temperature = args.temperature
        self.normalization = args.normalization
        self.soft =args.soft

        self.best_acc = best['accuracy']
        self.last_acc = last['accuracy']

        if 'class_accuracy' in best and isinstance(best['class_accuracy'], dict):
            for key, value in best['class_accuracy'].items():
                setattr(self, key, value)


def write_info(args, best_results, last_results):
    info = CGE_CLSInfo(args, best_results, last_results)
    info.write_results()
    return