#!/bin/sh
SCRIPT_DIR="$(cd "$(dirname "$0")" && pwd)"
#PROJECT_ROOT="$(cd "$SCRIPT_DIR/../../.." && pwd)"
PYTHON_FILE="${SCRIPT_DIR}/main.py"
DEVICE_IDX="0"
DATASET="shapes3d"
MODEL_TYPE="cgebetavae"
ENTITY="{YOUR WANDB ID}"
LATENT_DIM="6"
TRAIN_BATCH_SIZE="64"
TEST_BATCH_SIZE="512"
NUM_EPOCH="0"
MAX_STEPS="10"
SAVE_STEPS="100000000"
SEED="1"
BETA="1.0"
NUM_SAMPLING="6"
trap "exit" INT

for MODEL in $MODEL_TYPE
do
  for beta in $BETA
  do
    for EPOCH in $NUM_EPOCH
    do
      for BATCH in $TRAIN_BATCH_SIZE
      do
        for seed in $SEED
        do
          CUDA_VISIBLE_DEVICES=$DEVICE_IDX python $PYTHON_FILE \
          --device_idx $DEVICE_IDX \
          --dataset $DATASET\
          --project_name DL_${DATASET}_SUPPLE_TEST \
          --entity $ENTITY \
          --model_type $MODEL \
          --latent_dim $LATENT_DIM \
          --per_gpu_train_batch_size $BATCH \
          --test_batch_size $TEST_BATCH_SIZE \
          --num_epoch $EPOCH \
          --max_steps $MAX_STEPS \
          --save_steps $SAVE_STEPS \
          --beta $beta \
          --seed $seed \
          --quali_sampling $NUM_SAMPLING \
          --do_train --do_eval
        done
      done
    done
  done
done